/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.rest;

import io.netty.util.Recycler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.pulsar.broker.service.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMessagePublishContext
implements Topic.PublishContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestMessagePublishContext.class);
    private Topic topic;
    private long startTimeNs;
    private CompletableFuture<Position> positionFuture;
    private final Recycler.Handle<RestMessagePublishContext> recyclerHandle;
    private static final Recycler<RestMessagePublishContext> RECYCLER = new Recycler<RestMessagePublishContext>(){

        protected RestMessagePublishContext newObject(Recycler.Handle<RestMessagePublishContext> handle) {
            return new RestMessagePublishContext(handle);
        }
    };

    @Override
    public void completed(Exception exception, long ledgerId, long entryId) {
        if (exception != null) {
            this.positionFuture.completeExceptionally(exception);
            if (log.isInfoEnabled()) {
                log.info("Failed to write entry for rest produce request: ledgerId: {}, entryId: {}. triggered send callback.", (Object)ledgerId, (Object)entryId);
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Success write topic for rest produce request: {}, ledgerId: {}, entryId: {}. triggered send callback.", new Object[]{this.topic.getName(), ledgerId, entryId});
            }
            this.topic.recordAddLatency(System.nanoTime() - this.startTimeNs, TimeUnit.NANOSECONDS);
            this.positionFuture.complete(PositionFactory.create((long)ledgerId, (long)entryId));
        }
        this.recycle();
    }

    public static RestMessagePublishContext get(CompletableFuture<Position> positionFuture, Topic topic, long startTimeNs) {
        RestMessagePublishContext callback = (RestMessagePublishContext)RECYCLER.get();
        callback.positionFuture = positionFuture;
        callback.topic = topic;
        callback.startTimeNs = startTimeNs;
        return callback;
    }

    private RestMessagePublishContext(Recycler.Handle<RestMessagePublishContext> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.topic = null;
        this.startTimeNs = -1L;
        this.recyclerHandle.recycle((Object)this);
    }
}

