/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.service.AbstractBaseDispatcher;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.client.impl.Murmur3Hash32;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.Murmur3_32Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherSingleActiveConsumer
extends AbstractBaseDispatcher {
    private static final int MAX_RETRY_COUNT_FOR_ADD_CONSUMER_RACE = 5;
    protected final String topicName;
    private volatile Consumer activeConsumer = null;
    protected final CopyOnWriteArrayList<Consumer> consumers;
    protected StickyKeyConsumerSelector stickyKeyConsumerSelector;
    protected boolean isKeyHashRangeFiltered = false;
    protected CompletableFuture<Void> closeFuture = null;
    protected final int partitionIndex;
    protected final ManagedCursor cursor;
    protected final CommandSubscribe.SubType subscriptionType;
    protected static final int FALSE = 0;
    protected static final int TRUE = 1;
    protected static final AtomicIntegerFieldUpdater<AbstractDispatcherSingleActiveConsumer> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDispatcherSingleActiveConsumer.class, "isClosed");
    private volatile int isClosed = 0;
    protected boolean isFirstRead = true;
    private static final int CONSUMER_CONSISTENT_HASH_REPLICAS = 100;
    private static final Logger log = LoggerFactory.getLogger(AbstractDispatcherSingleActiveConsumer.class);

    public AbstractDispatcherSingleActiveConsumer(CommandSubscribe.SubType subscriptionType, int partitionIndex, String topicName, Subscription subscription, ServiceConfiguration serviceConfig, ManagedCursor cursor) {
        super(subscription, serviceConfig);
        this.topicName = topicName;
        this.consumers = new CopyOnWriteArrayList();
        this.partitionIndex = partitionIndex;
        this.subscriptionType = subscriptionType;
        this.cursor = cursor;
    }

    protected abstract void scheduleReadOnActiveConsumer();

    protected abstract void cancelPendingRead();

    protected void notifyActiveConsumerChanged(Consumer activeConsumer) {
        if (null != activeConsumer && this.subscriptionType == CommandSubscribe.SubType.Failover) {
            this.consumers.forEach(consumer -> consumer.notifyActiveConsumerChange(activeConsumer));
        }
    }

    protected boolean pickAndScheduleActiveConsumer() {
        int index;
        Consumer selectedConsumer;
        Preconditions.checkArgument((!this.consumers.isEmpty() ? 1 : 0) != 0);
        AtomicBoolean hasPriorityConsumer = new AtomicBoolean(false);
        this.consumers.sort((c1, c2) -> {
            int priority = c1.getPriorityLevel() - c2.getPriorityLevel();
            if (priority != 0) {
                hasPriorityConsumer.set(true);
                return priority;
            }
            return c1.consumerName().compareTo(c2.consumerName());
        });
        int consumersSize = this.consumers.size();
        if (hasPriorityConsumer.get()) {
            int highestPriorityLevel = this.consumers.get(0).getPriorityLevel();
            for (int i = 0; i < this.consumers.size(); ++i) {
                if (highestPriorityLevel == this.consumers.get(i).getPriorityLevel()) continue;
                consumersSize = i;
                break;
            }
        }
        if ((selectedConsumer = this.consumers.get(index = this.partitionIndex >= 0 && !this.serviceConfig.isActiveConsumerFailoverConsistentHashing() ? this.partitionIndex % consumersSize : this.peekConsumerIndexFromHashRing(this.makeHashRing(consumersSize)))) == this.activeConsumer) {
            return false;
        }
        this.activeConsumer = selectedConsumer;
        this.scheduleReadOnActiveConsumer();
        return true;
    }

    private int peekConsumerIndexFromHashRing(NavigableMap<Integer, Integer> hashRing) {
        int hash = Murmur3Hash32.getInstance().makeHash(this.topicName);
        Map.Entry<Integer, Integer> ceilingEntry = hashRing.ceilingEntry(hash);
        return ceilingEntry != null ? ceilingEntry.getValue() : hashRing.firstEntry().getValue();
    }

    private NavigableMap<Integer, Integer> makeHashRing(int consumerSize) {
        TreeMap<Integer, Integer> hashRing = new TreeMap<Integer, Integer>();
        for (int i = 0; i < consumerSize; ++i) {
            for (int j = 0; j < 100; ++j) {
                String key = this.consumers.get(i).consumerName() + j;
                int hash = Murmur3_32Hash.getInstance().makeHash(key.getBytes());
                hashRing.put(hash, i);
            }
        }
        return Collections.unmodifiableNavigableMap(hashRing);
    }

    @Override
    public CompletableFuture<Void> addConsumer(Consumer consumer) {
        return this.internalAddConsumer(consumer, 0);
    }

    private synchronized CompletableFuture<Void> internalAddConsumer(Consumer consumer, int retryCount) {
        if (IS_CLOSED_UPDATER.get(this) == 1) {
            log.warn("[{}] Dispatcher is already closed. Closing consumer {}", (Object)this.topicName, (Object)consumer);
            consumer.disconnect();
            return CompletableFuture.completedFuture(null);
        }
        if (this.subscriptionType == CommandSubscribe.SubType.Exclusive && !this.consumers.isEmpty()) {
            Consumer actConsumer = this.getActiveConsumer();
            if (actConsumer != null) {
                Thread callerThread = Thread.currentThread();
                return actConsumer.cnx().checkConnectionLiveness().thenCompose(actConsumerStillAlive -> {
                    if (actConsumerStillAlive.isEmpty() || ((Boolean)actConsumerStillAlive.get()).booleanValue()) {
                        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Exclusive consumer is already connected"));
                    }
                    if (retryCount >= 5) {
                        log.warn("[{}] The active consumer's connection is still inactive after all retries {}, skip adding new consumer {}", new Object[]{this.getName(), actConsumer, consumer});
                        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Exclusive consumer is already connected after 5 attempts"));
                    }
                    if (Thread.currentThread().equals(callerThread)) {
                        log.warn("[{}] race condition happened that cnx of the active consumer ({}) is inactive but it's not removed, retrying", (Object)this.getName(), (Object)actConsumer);
                        CompletableFuture future = new CompletableFuture();
                        CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> future.complete(null));
                        return future.thenCompose(__ -> this.internalAddConsumer(consumer, retryCount + 1));
                    }
                    return this.internalAddConsumer(consumer, retryCount + 1);
                });
            }
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Active consumer is in a strange state. Active consumer is null, but there are " + this.consumers.size() + " registered."));
        }
        if (this.subscriptionType == CommandSubscribe.SubType.Failover && this.isConsumersExceededOnSubscription()) {
            log.warn("[{}] Attempting to add consumer to subscription which reached max consumers limit", (Object)this.topicName);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Subscription reached max consumers limit"));
        }
        if (this.subscriptionType == CommandSubscribe.SubType.Exclusive && consumer.getKeySharedMeta() != null && consumer.getKeySharedMeta().getHashRangesList() != null && consumer.getKeySharedMeta().getHashRangesList().size() > 0) {
            this.stickyKeyConsumerSelector = new HashRangeExclusiveStickyKeyConsumerSelector();
            this.stickyKeyConsumerSelector.addConsumer(consumer);
            this.isKeyHashRangeFiltered = true;
        } else {
            this.isKeyHashRangeFiltered = false;
        }
        if (this.consumers.isEmpty()) {
            this.isFirstRead = true;
        }
        this.consumers.add(consumer);
        if (!this.pickAndScheduleActiveConsumer()) {
            Consumer currentActiveConsumer = this.getActiveConsumer();
            if (null == currentActiveConsumer) {
                if (log.isDebugEnabled()) {
                    log.debug("Current active consumer disappears while adding consumer {}", (Object)consumer);
                }
            } else {
                consumer.notifyActiveConsumerChange(currentActiveConsumer);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        log.info("Removing consumer {}", (Object)consumer);
        if (!this.consumers.remove(consumer)) {
            throw new BrokerServiceException.ServerMetadataException("Consumer was not connected");
        }
        if (this.consumers.isEmpty()) {
            this.activeConsumer = null;
        }
        if (this.closeFuture == null && !this.consumers.isEmpty()) {
            this.pickAndScheduleActiveConsumer();
            return;
        }
        this.cancelPendingRead();
        if (this.consumers.isEmpty() && this.closeFuture != null && !this.closeFuture.isDone()) {
            this.closeFuture.complete(null);
        }
    }

    @Override
    public synchronized boolean canUnsubscribe(Consumer consumer) {
        return this.consumers.size() == 1 && Objects.equals(consumer, this.activeConsumer);
    }

    @Override
    public CompletableFuture<Void> close(boolean disconnectConsumers, Optional<BrokerLookupData> assignedBrokerLookupData) {
        IS_CLOSED_UPDATER.set(this, 1);
        this.getRateLimiter().ifPresent(DispatchRateLimiter::close);
        return disconnectConsumers ? this.disconnectAllConsumers(false, assignedBrokerLookupData) : CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed == 1;
    }

    @Override
    public synchronized CompletableFuture<Void> disconnectAllConsumers(boolean isResetCursor, Optional<BrokerLookupData> assignedBrokerLookupData) {
        this.closeFuture = new CompletableFuture();
        if (!this.consumers.isEmpty()) {
            this.consumers.forEach(consumer -> consumer.disconnect(isResetCursor, assignedBrokerLookupData));
            this.cancelPendingRead();
        } else {
            this.closeFuture.complete(null);
        }
        return this.closeFuture;
    }

    @Override
    public synchronized CompletableFuture<Void> disconnectActiveConsumers(boolean isResetCursor) {
        this.closeFuture = new CompletableFuture();
        if (this.activeConsumer != null) {
            this.activeConsumer.disconnect(isResetCursor);
        }
        this.closeFuture.complete(null);
        return this.closeFuture;
    }

    @Override
    public synchronized void resetCloseFuture() {
        this.closeFuture = null;
    }

    @Override
    public void reset() {
        this.resetCloseFuture();
        IS_CLOSED_UPDATER.set(this, 0);
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return this.subscriptionType;
    }

    public Consumer getActiveConsumer() {
        return this.activeConsumer;
    }

    @Override
    public List<Consumer> getConsumers() {
        return this.consumers;
    }

    @Override
    public boolean isConsumerConnected() {
        return this.activeConsumer != null;
    }
}

