/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.transaction.buffer.AbortedTxnProcessor;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferReader;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.broker.transaction.buffer.impl.SingleSnapshotAbortedTxnProcessorImpl;
import org.apache.pulsar.broker.transaction.buffer.impl.SnapshotSegmentAbortedTxnProcessorImpl;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferRecoverCallBack;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferState;
import org.apache.pulsar.broker.transaction.buffer.metadata.TransactionBufferSnapshot;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.Markers;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RecoverTimeRecord;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicTransactionBuffer
extends TopicTransactionBufferState
implements TransactionBuffer,
TimerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicTransactionBuffer.class);
    private final PersistentTopic topic;
    private volatile Position maxReadPosition;
    private final LinkedMap<TxnID, Position> ongoingTxns = new LinkedMap();
    private final AtomicLong changeMaxReadPositionCount = new AtomicLong();
    private final LongAdder txnCommittedCounter = new LongAdder();
    private final LongAdder txnAbortedCounter = new LongAdder();
    private final Timer timer;
    private final int takeSnapshotIntervalNumber;
    private final int takeSnapshotIntervalTime;
    private final CompletableFuture<Void> transactionBufferFuture = new CompletableFuture();
    private final ConcurrentHashMap<Long, Long> lowWaterMarks = new ConcurrentHashMap();
    public final RecoverTimeRecord recoverTime = new RecoverTimeRecord();
    private final Semaphore handleLowWaterMark = new Semaphore(1);
    private final AbortedTxnProcessor snapshotAbortedTxnProcessor;
    private final AbortedTxnProcessor.SnapshotType snapshotType;
    private final MaxReadPositionCallBack maxReadPositionCallBack;
    private final LinkedList<PendingAppendingTxnBufferTask> pendingAppendingTxnBufferTasks = new LinkedList();

    private static AbortedTxnProcessor createSnapshotProcessor(PersistentTopic topic) {
        return topic.getBrokerService().getPulsar().getConfiguration().isTransactionBufferSegmentedSnapshotEnabled() ? new SnapshotSegmentAbortedTxnProcessorImpl(topic) : new SingleSnapshotAbortedTxnProcessorImpl(topic);
    }

    private static AbortedTxnProcessor.SnapshotType determineSnapshotType(PersistentTopic topic) {
        return topic.getBrokerService().getPulsar().getConfiguration().isTransactionBufferSegmentedSnapshotEnabled() ? AbortedTxnProcessor.SnapshotType.Segment : AbortedTxnProcessor.SnapshotType.Single;
    }

    public TopicTransactionBuffer(PersistentTopic topic) {
        this(topic, TopicTransactionBuffer.createSnapshotProcessor(topic), TopicTransactionBuffer.determineSnapshotType(topic));
    }

    @VisibleForTesting
    TopicTransactionBuffer(PersistentTopic topic, AbortedTxnProcessor snapshotAbortedTxnProcessor, AbortedTxnProcessor.SnapshotType snapshotType) {
        super(TopicTransactionBufferState.State.None);
        this.topic = topic;
        this.timer = topic.getBrokerService().getPulsar().getTransactionTimer();
        this.takeSnapshotIntervalNumber = topic.getBrokerService().getPulsar().getConfiguration().getTransactionBufferSnapshotMaxTransactionCount();
        this.takeSnapshotIntervalTime = topic.getBrokerService().getPulsar().getConfiguration().getTransactionBufferSnapshotMinTimeInMillis();
        this.maxReadPosition = topic.getManagedLedger().getLastConfirmedEntry();
        this.snapshotAbortedTxnProcessor = snapshotAbortedTxnProcessor;
        this.snapshotType = snapshotType;
        this.maxReadPositionCallBack = topic.getMaxReadPositionCallBack();
        this.recover();
    }

    private void recover() {
        this.recoverTime.setRecoverStartTime(System.currentTimeMillis());
        this.topic.getBrokerService().getPulsar().getTransactionExecutorProvider().getExecutor((Object)this).execute(new TopicTransactionBufferRecover(new TopicTransactionBufferRecoverCallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoverComplete() {
                TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                synchronized (topicTransactionBuffer) {
                    if (TopicTransactionBuffer.this.ongoingTxns.isEmpty()) {
                        TopicTransactionBuffer.this.maxReadPosition = TopicTransactionBuffer.this.topic.getManagedLedger().getLastConfirmedEntry();
                    }
                    if (!TopicTransactionBuffer.this.changeToReadyState()) {
                        log.error("[{}]Transaction buffer recover fail, current state: {}", (Object)TopicTransactionBuffer.this.topic.getName(), (Object)TopicTransactionBuffer.this.getState());
                        TopicTransactionBuffer.this.getTransactionBufferFuture().completeExceptionally(new BrokerServiceException.ServiceUnitNotReadyException("Transaction buffer recover failed to change the status to Ready,current state is: " + String.valueOf((Object)TopicTransactionBuffer.this.getState())));
                    } else {
                        TopicTransactionBuffer.this.timer.newTimeout((TimerTask)TopicTransactionBuffer.this, (long)TopicTransactionBuffer.this.takeSnapshotIntervalTime, TimeUnit.MILLISECONDS);
                        TopicTransactionBuffer.this.getTransactionBufferFuture().complete(null);
                        TopicTransactionBuffer.this.recoverTime.setRecoverEndTime(System.currentTimeMillis());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noNeedToRecover() {
                TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                synchronized (topicTransactionBuffer) {
                    TopicTransactionBuffer.this.maxReadPosition = TopicTransactionBuffer.this.topic.getManagedLedger().getLastConfirmedEntry();
                    if (!TopicTransactionBuffer.this.changeToNoSnapshotState()) {
                        log.error("[{}]Transaction buffer recover fail", (Object)TopicTransactionBuffer.this.topic.getName());
                    } else {
                        TopicTransactionBuffer.this.getTransactionBufferFuture().complete(null);
                        TopicTransactionBuffer.this.recoverTime.setRecoverEndTime(System.currentTimeMillis());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleTxnEntry(Entry entry) {
                ByteBuf metadataAndPayload = entry.getDataBuffer();
                MessageMetadata msgMetadata = Commands.peekMessageMetadata((ByteBuf)metadataAndPayload, (String)"transaction-buffer-sub", (long)-1L);
                if (msgMetadata != null && msgMetadata.hasTxnidMostBits() && msgMetadata.hasTxnidLeastBits()) {
                    TxnID txnID = new TxnID(msgMetadata.getTxnidMostBits(), msgMetadata.getTxnidLeastBits());
                    Position position = PositionFactory.create((long)entry.getLedgerId(), (long)entry.getEntryId());
                    TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                    synchronized (topicTransactionBuffer) {
                        if (Markers.isTxnMarker((MessageMetadata)msgMetadata)) {
                            if (Markers.isTxnAbortMarker((MessageMetadata)msgMetadata)) {
                                TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.putAbortedTxnAndPosition(txnID, position);
                            }
                            TopicTransactionBuffer.this.removeTxnAndUpdateMaxReadPosition(txnID);
                        } else {
                            TopicTransactionBuffer.this.handleTransactionMessage(txnID, position);
                        }
                    }
                }
            }

            @Override
            public void recoverExceptionally(Throwable e) {
                log.warn("Closing topic {} due to read transaction buffer snapshot while recovering the transaction buffer throw exception", (Object)TopicTransactionBuffer.this.topic.getName(), (Object)e);
                if (e instanceof PulsarClientException) {
                    TopicTransactionBuffer.this.getTransactionBufferFuture().completeExceptionally(new BrokerServiceException.ServiceUnitNotReadyException(e.getMessage(), e));
                } else {
                    TopicTransactionBuffer.this.getTransactionBufferFuture().completeExceptionally(e);
                }
                TopicTransactionBuffer.this.recoverTime.setRecoverEndTime(System.currentTimeMillis());
                TopicTransactionBuffer.this.topic.close(true);
            }
        }, this.topic, this, this.snapshotAbortedTxnProcessor));
    }

    @Override
    public CompletableFuture<TransactionMeta> getTransactionMeta(TxnID txnID) {
        return CompletableFuture.completedFuture(null);
    }

    @VisibleForTesting
    public CompletableFuture<Void> getTransactionBufferFuture() {
        return this.transactionBufferFuture;
    }

    @Override
    public CompletableFuture<Void> checkIfTBRecoverCompletely() {
        return this.getTransactionBufferFuture();
    }

    @Override
    public long getOngoingTxnCount() {
        return this.ongoingTxns.size();
    }

    @Override
    public long getAbortedTxnCount() {
        return this.txnAbortedCounter.sum();
    }

    @Override
    public long getCommittedTxnCount() {
        return this.txnCommittedCounter.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Position> appendBufferToTxn(TxnID txnId, long sequenceId, ByteBuf buffer) {
        LinkedList<PendingAppendingTxnBufferTask> linkedList = this.pendingAppendingTxnBufferTasks;
        synchronized (linkedList) {
            if (!this.pendingAppendingTxnBufferTasks.isEmpty()) {
                CompletableFuture<Position> res = new CompletableFuture<Position>();
                buffer.retain();
                this.pendingAppendingTxnBufferTasks.offer(new PendingAppendingTxnBufferTask(txnId, sequenceId, buffer, res));
                return res;
            }
            if (!(this.checkIfReady() || this.checkIfNoSnapshot() || this.checkIfFirstSnapshotting() || this.checkIfInitializing())) {
                log.error("[{}] unexpected state: {} when try to take the first transaction buffer snapshot", (Object)this.topic.getName(), (Object)this.getState());
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ServiceUnitNotReadyException("Transaction Buffer recover failed, the current state is: " + String.valueOf((Object)this.getState())));
            }
            if (this.checkIfReady()) {
                return this.internalAppendBufferToTxn(txnId, buffer, sequenceId);
            }
            CompletableFuture<Position> res = new CompletableFuture<Position>();
            buffer.retain();
            this.pendingAppendingTxnBufferTasks.offer(new PendingAppendingTxnBufferTask(txnId, sequenceId, buffer, res));
            Consumer<Throwable> failPendingTasks = throwable -> {
                LinkedList<PendingAppendingTxnBufferTask> linkedList = this.pendingAppendingTxnBufferTasks;
                synchronized (linkedList) {
                    PendingAppendingTxnBufferTask pendingTask = null;
                    while ((pendingTask = this.pendingAppendingTxnBufferTasks.poll()) != null) {
                        pendingTask.fail((Throwable)throwable);
                    }
                }
            };
            Runnable flushPendingTasks = () -> {
                PendingAppendingTxnBufferTask pendingTask = null;
                try {
                    LinkedList<PendingAppendingTxnBufferTask> linkedList = this.pendingAppendingTxnBufferTasks;
                    synchronized (linkedList) {
                        while ((pendingTask = this.pendingAppendingTxnBufferTasks.poll()) != null) {
                            ByteBuf data = pendingTask.buffer;
                            CompletableFuture<Position> pendingFuture = pendingTask.pendingPublishFuture;
                            this.internalAppendBufferToTxn(pendingTask.txnId, pendingTask.buffer, pendingTask.sequenceId).whenComplete((positionAdded, ex3) -> {
                                data.release();
                                if (ex3 != null) {
                                    pendingFuture.completeExceptionally((Throwable)ex3);
                                    return;
                                }
                                pendingFuture.complete((Position)positionAdded);
                            });
                        }
                    }
                }
                catch (Exception e) {
                    log.error("[{}] Failed to flush pending publishing requests after taking the first snapshot.", (Object)this.topic.getName(), (Object)e);
                    if (pendingTask != null) {
                        pendingTask.fail(e);
                    }
                    failPendingTasks.accept(e);
                }
            };
            this.transactionBufferFuture.whenComplete((ignore1, ex1) -> {
                if (ex1 != null) {
                    log.error("[{}] Transaction buffer recover failed", (Object)this.topic.getName(), ex1);
                    failPendingTasks.accept((Throwable)ex1);
                    return;
                }
                if (this.changeToFirstSnapshotting()) {
                    log.info("[{}] Start to take the first snapshot", (Object)this.topic.getName());
                    this.takeFirstSnapshot().whenComplete((ignore2, ex2) -> {
                        if (ex2 != null) {
                            log.error("[{}] Failed to take the first snapshot, flushing failed publishing requests", (Object)this.topic.getName(), ex2);
                            failPendingTasks.accept((Throwable)ex2);
                            return;
                        }
                        log.info("[{}] Finished to take the first snapshot, flushing publishing {} requests", (Object)this.topic.getName(), (Object)this.pendingAppendingTxnBufferTasks.size());
                        flushPendingTasks.run();
                    });
                } else if (this.checkIfReady()) {
                    log.info("[{}] No need to take the first snapshot, flushing publishing {} requests", (Object)this.topic.getName(), (Object)this.pendingAppendingTxnBufferTasks.size());
                    flushPendingTasks.run();
                } else {
                    log.error("[{}] Transaction buffer recover failed, current state is {}", (Object)this.topic.getName(), (Object)this.getState());
                    failPendingTasks.accept(new BrokerServiceException.ServiceUnitNotReadyException("Transaction Buffer recover failed, the current state is: " + String.valueOf((Object)this.getState())));
                }
            });
            return res;
        }
    }

    private CompletableFuture<Void> takeFirstSnapshot() {
        CompletableFuture<Void> firstSnapshottingFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.snapshotAbortedTxnProcessor.takeAbortedTxnsSnapshot(this.maxReadPosition).thenRun(() -> {
            if (this.changeToReadyStateFromNoSnapshot()) {
                this.timer.newTimeout((TimerTask)this, (long)this.takeSnapshotIntervalTime, TimeUnit.MILLISECONDS);
                firstSnapshottingFuture.complete(null);
            } else {
                log.error("[{}]Failed to change state of transaction buffer to Ready from NoSnapshot", (Object)this.topic.getName());
                firstSnapshottingFuture.completeExceptionally(new BrokerServiceException.ServiceUnitNotReadyException("Transaction Buffer take first snapshot failed, the current state is: " + String.valueOf((Object)this.getState())));
            }
        })).exceptionally(exception -> {
            log.error("Topic {} failed to take snapshot", (Object)this.topic.getName());
            firstSnapshottingFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return firstSnapshottingFuture;
    }

    @VisibleForTesting
    protected CompletableFuture<Position> internalAppendBufferToTxn(final TxnID txnId, ByteBuf buffer, long seq) {
        final CompletableFuture<Position> completableFuture = new CompletableFuture<Position>();
        Long lowWaterMark = this.lowWaterMarks.get(txnId.getMostSigBits());
        if (lowWaterMark != null && lowWaterMark >= txnId.getLeastSigBits()) {
            completableFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Transaction [" + String.valueOf(txnId) + "] has been ended. Please use a new transaction to send message."));
            return completableFuture;
        }
        this.topic.getManagedLedger().asyncAddEntry(buffer, new AsyncCallbacks.AddEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                synchronized (topicTransactionBuffer) {
                    TopicTransactionBuffer.this.handleTransactionMessage(txnId, position);
                }
                completableFuture.complete(position);
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Failed to append buffer to txn {}", (Object)txnId, (Object)exception);
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    private void handleTransactionMessage(TxnID txnId, Position position) {
        if (!this.ongoingTxns.containsKey((Object)txnId) && !this.snapshotAbortedTxnProcessor.checkAbortedTransaction(txnId)) {
            this.ongoingTxns.put((Object)txnId, (Object)position);
            Position firstPosition = (Position)this.ongoingTxns.get(this.ongoingTxns.firstKey());
            this.updateMaxReadPosition(this.topic.getManagedLedger().getPreviousPosition(firstPosition), false);
        }
    }

    private void updateLastDispatchablePosition(Position position) {
        this.topic.updateLastDispatchablePosition(position);
    }

    @Override
    public CompletableFuture<TransactionBufferReader> openTransactionBufferReader(TxnID txnID, long startSequenceId) {
        return null;
    }

    @Override
    public CompletableFuture<Void> commitTxn(final TxnID txnID, final long lowWaterMark) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction {} commit on topic {}.", (Object)txnID.toString(), (Object)this.topic.getName());
        }
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.getTransactionBufferFuture().thenRun(() -> {
            ByteBuf commitMarker = Markers.newTxnCommitMarker((long)-1L, (long)txnID.getMostSigBits(), (long)txnID.getLeastSigBits());
            try {
                this.topic.getManagedLedger().asyncAddEntry(commitMarker, new AsyncCallbacks.AddEntryCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                        TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                        synchronized (topicTransactionBuffer) {
                            TopicTransactionBuffer.this.removeTxnAndUpdateMaxReadPosition(txnID);
                            TopicTransactionBuffer.this.handleLowWaterMark(txnID, lowWaterMark);
                            TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.trimExpiredAbortedTxns();
                            TopicTransactionBuffer.this.takeSnapshotByChangeTimes();
                        }
                        TopicTransactionBuffer.this.txnCommittedCounter.increment();
                        completableFuture.complete(null);
                    }

                    public void addFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("Failed to commit for txn {}", (Object)txnID, (Object)exception);
                        TopicTransactionBuffer.this.checkAppendMarkerException(exception);
                        completableFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                    }
                }, null);
            }
            finally {
                commitMarker.release();
            }
        })).exceptionally(exception -> {
            log.error("Transaction {} commit on topic {}.", new Object[]{txnID.toString(), this.topic.getName(), exception.getCause()});
            completableFuture.completeExceptionally(exception.getCause());
            return null;
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> abortTxn(final TxnID txnID, final long lowWaterMark) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction {} abort on topic {}.", (Object)txnID.toString(), (Object)this.topic.getName());
        }
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.getTransactionBufferFuture().thenRun(() -> {
            if (!this.checkIfReady()) {
                completableFuture.complete(null);
                return;
            }
            ByteBuf abortMarker = Markers.newTxnAbortMarker((long)-1L, (long)txnID.getMostSigBits(), (long)txnID.getLeastSigBits());
            try {
                this.topic.getManagedLedger().asyncAddEntry(abortMarker, new AsyncCallbacks.AddEntryCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                        TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                        synchronized (topicTransactionBuffer) {
                            TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.putAbortedTxnAndPosition(txnID, position);
                            TopicTransactionBuffer.this.removeTxnAndUpdateMaxReadPosition(txnID);
                            TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.trimExpiredAbortedTxns();
                            TopicTransactionBuffer.this.takeSnapshotByChangeTimes();
                            TopicTransactionBuffer.this.txnAbortedCounter.increment();
                            completableFuture.complete(null);
                            TopicTransactionBuffer.this.handleLowWaterMark(txnID, lowWaterMark);
                        }
                    }

                    public void addFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("Failed to abort for txn {}", (Object)txnID, (Object)exception);
                        TopicTransactionBuffer.this.checkAppendMarkerException(exception);
                        completableFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                    }
                }, null);
            }
            finally {
                abortMarker.release();
            }
        })).exceptionally(exception -> {
            log.error("Transaction {} abort on topic {}.", new Object[]{txnID.toString(), this.topic.getName(), exception.getCause()});
            completableFuture.completeExceptionally(exception.getCause());
            return null;
        });
        return completableFuture;
    }

    private void checkAppendMarkerException(ManagedLedgerException exception) {
        if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
            this.topic.getManagedLedger().readyToCreateNewLedger();
        }
    }

    private void handleLowWaterMark(TxnID txnID, long lowWaterMark) {
        this.lowWaterMarks.compute(txnID.getMostSigBits(), (tcId, oldLowWaterMark) -> {
            if (oldLowWaterMark == null || oldLowWaterMark < lowWaterMark) {
                return lowWaterMark;
            }
            return oldLowWaterMark;
        });
        if (this.handleLowWaterMark.tryAcquire()) {
            TxnID firstTxn;
            long tCId;
            Long lowWaterMarkOfFirstTxnId;
            if (!this.ongoingTxns.isEmpty() && (lowWaterMarkOfFirstTxnId = this.lowWaterMarks.get(tCId = (firstTxn = (TxnID)this.ongoingTxns.firstKey()).getMostSigBits())) != null && firstTxn.getLeastSigBits() <= lowWaterMarkOfFirstTxnId) {
                ((CompletableFuture)this.abortTxn(firstTxn, lowWaterMarkOfFirstTxnId).thenRun(() -> {
                    log.warn("Successes to abort low water mark for txn [{}], topic [{}], lowWaterMark [{}]", new Object[]{firstTxn, this.topic.getName(), lowWaterMarkOfFirstTxnId});
                    this.handleLowWaterMark.release();
                })).exceptionally(ex -> {
                    log.warn("Failed to abort low water mark for txn {}, topic [{}], lowWaterMark [{}], ", new Object[]{firstTxn, this.topic.getName(), lowWaterMarkOfFirstTxnId, ex});
                    this.handleLowWaterMark.release();
                    return null;
                });
                return;
            }
            this.handleLowWaterMark.release();
        }
    }

    private void takeSnapshotByChangeTimes() {
        if (this.changeMaxReadPositionCount.get() >= (long)this.takeSnapshotIntervalNumber) {
            this.changeMaxReadPositionCount.set(0L);
            this.snapshotAbortedTxnProcessor.takeAbortedTxnsSnapshot(this.maxReadPosition);
        }
    }

    private void takeSnapshotByTimeout() {
        if (this.changeMaxReadPositionCount.get() > 0L) {
            this.changeMaxReadPositionCount.set(0L);
            this.snapshotAbortedTxnProcessor.takeAbortedTxnsSnapshot(this.maxReadPosition);
        }
        this.timer.newTimeout((TimerTask)this, (long)this.takeSnapshotIntervalTime, TimeUnit.MILLISECONDS);
    }

    void removeTxnAndUpdateMaxReadPosition(TxnID txnID) {
        this.ongoingTxns.remove((Object)txnID);
        if (!this.ongoingTxns.isEmpty()) {
            Position position = (Position)this.ongoingTxns.get(this.ongoingTxns.firstKey());
            this.updateMaxReadPosition(this.topic.getManagedLedger().getPreviousPosition(position), false);
        } else {
            this.updateMaxReadPosition(this.topic.getManagedLedger().getLastConfirmedEntry(), false);
        }
        this.updateLastDispatchablePosition(null);
    }

    void updateMaxReadPosition(Position newPosition, boolean disableCallback) {
        Position preMaxReadPosition = this.maxReadPosition;
        this.maxReadPosition = newPosition;
        if (preMaxReadPosition.compareTo(this.maxReadPosition) < 0) {
            if (!this.checkIfNoSnapshot()) {
                this.changeMaxReadPositionCount.getAndIncrement();
            }
            if (!disableCallback) {
                this.maxReadPositionCallBack.maxReadPositionMovedForward(preMaxReadPosition, this.maxReadPosition);
            }
        }
    }

    @Override
    public CompletableFuture<Void> purgeTxns(List<Long> dataLedgers) {
        return null;
    }

    @Override
    public CompletableFuture<Void> clearSnapshot() {
        return this.snapshotAbortedTxnProcessor.clearAbortedTxnSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> closeAsync() {
        LinkedList<PendingAppendingTxnBufferTask> linkedList = this.pendingAppendingTxnBufferTasks;
        synchronized (linkedList) {
            if (!this.checkIfClosed()) {
                PendingAppendingTxnBufferTask pendingTask = null;
                BrokerServiceException.ServiceUnitNotReadyException t = new BrokerServiceException.ServiceUnitNotReadyException("Topic is closed");
                while ((pendingTask = this.pendingAppendingTxnBufferTasks.poll()) != null) {
                    pendingTask.fail(t);
                }
            }
            this.changeToCloseState();
        }
        return this.snapshotAbortedTxnProcessor.closeAsync();
    }

    @Override
    public synchronized boolean isTxnAborted(TxnID txnID, Position readPosition) {
        return this.snapshotAbortedTxnProcessor.checkAbortedTransaction(txnID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncMaxReadPositionForNormalPublish(Position position, boolean isMarkerMessage) {
        TopicTransactionBuffer topicTransactionBuffer = this;
        synchronized (topicTransactionBuffer) {
            if (this.checkIfNoSnapshot()) {
                this.updateMaxReadPosition(position, isMarkerMessage);
            } else if (this.checkIfReady() && this.ongoingTxns.isEmpty()) {
                this.updateMaxReadPosition(position, isMarkerMessage);
            }
        }
        if (!isMarkerMessage) {
            this.updateLastDispatchablePosition(position);
        }
    }

    @Override
    public AbortedTxnProcessor.SnapshotType getSnapshotType() {
        return this.snapshotType;
    }

    @Override
    public Position getMaxReadPosition() {
        if (this.checkIfReady() || this.checkIfNoSnapshot()) {
            return this.maxReadPosition;
        }
        return PositionFactory.EARLIEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionInBufferStats getTransactionInBufferStats(TxnID txnID) {
        TransactionInBufferStats transactionInBufferStats = new TransactionInBufferStats();
        TopicTransactionBuffer topicTransactionBuffer = this;
        synchronized (topicTransactionBuffer) {
            transactionInBufferStats.aborted = this.isTxnAborted(txnID, null);
            if (this.ongoingTxns.containsKey((Object)txnID)) {
                transactionInBufferStats.startPosition = ((Position)this.ongoingTxns.get((Object)txnID)).toString();
            }
        }
        return transactionInBufferStats;
    }

    @Override
    public TransactionBufferStats getStats(boolean lowWaterMarks, boolean segmentStats) {
        TransactionBufferStats transactionBufferStats = this.snapshotAbortedTxnProcessor.generateSnapshotStats(segmentStats);
        transactionBufferStats.snapshotType = this.snapshotType.toString();
        transactionBufferStats.state = this.getState().name();
        transactionBufferStats.maxReadPosition = this.maxReadPosition.toString();
        if (lowWaterMarks) {
            transactionBufferStats.lowWaterMarks = this.lowWaterMarks;
        }
        transactionBufferStats.ongoingTxnSize = this.ongoingTxns.size();
        transactionBufferStats.recoverStartTime = this.recoverTime.getRecoverStartTime();
        transactionBufferStats.recoverEndTime = this.recoverTime.getRecoverEndTime();
        return transactionBufferStats;
    }

    @Override
    public TransactionBufferStats getStats(boolean lowWaterMarks) {
        return this.getStats(lowWaterMarks, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) {
        if (this.checkIfReady()) {
            TopicTransactionBuffer topicTransactionBuffer = this;
            synchronized (topicTransactionBuffer) {
                this.takeSnapshotByTimeout();
            }
        }
    }

    public static interface MaxReadPositionCallBack {
        public void maxReadPositionMovedForward(Position var1, Position var2);
    }

    @VisibleForTesting
    public static class TopicTransactionBufferRecover
    implements Runnable {
        private final PersistentTopic topic;
        private final TopicTransactionBufferRecoverCallBack callBack;
        private Position startReadCursorPosition = PositionFactory.EARLIEST;
        private final SpscArrayQueue<Entry> entryQueue;
        private final AtomicLong exceptionNumber = new AtomicLong();
        public static final String SUBSCRIPTION_NAME = "transaction-buffer-sub";
        private final TopicTransactionBuffer topicTransactionBuffer;
        private final AbortedTxnProcessor abortedTxnProcessor;

        private TopicTransactionBufferRecover(TopicTransactionBufferRecoverCallBack callBack, PersistentTopic topic, TopicTransactionBuffer transactionBuffer, AbortedTxnProcessor abortedTxnProcessor) {
            this.topic = topic;
            this.callBack = callBack;
            this.entryQueue = new SpscArrayQueue(2000);
            this.topicTransactionBuffer = transactionBuffer;
            this.abortedTxnProcessor = abortedTxnProcessor;
        }

        @Override
        public void run() {
            if (!this.topicTransactionBuffer.changeToInitializingState()) {
                log.warn("TransactionBuffer {} of topic {} can not change state to Initializing", (Object)this, (Object)this.topic.getName());
                return;
            }
            ((CompletableFuture)this.abortedTxnProcessor.recoverFromSnapshot().thenAccept(startReadCursorPosition -> {
                ManagedCursor managedCursor;
                if (startReadCursorPosition == null) {
                    this.callBack.noNeedToRecover();
                    return;
                }
                this.startReadCursorPosition = startReadCursorPosition;
                try {
                    managedCursor = this.topic.getManagedLedger().newNonDurableCursor(this.startReadCursorPosition, SUBSCRIPTION_NAME);
                }
                catch (ManagedLedgerException e) {
                    this.callBack.recoverExceptionally(e);
                    log.error("[{}]Transaction buffer recover fail when open cursor!", (Object)this.topic.getName(), (Object)e);
                    return;
                }
                Position lastConfirmedEntry = this.topic.getManagedLedger().getLastConfirmedEntry();
                Position currentLoadPosition = this.startReadCursorPosition;
                FillEntryQueueCallback fillEntryQueueCallback = new FillEntryQueueCallback(this.entryQueue, managedCursor, this);
                if (lastConfirmedEntry.getEntryId() != -1L) {
                    while (lastConfirmedEntry.compareTo(currentLoadPosition) > 0 && fillEntryQueueCallback.fillQueue()) {
                        Entry entry = (Entry)this.entryQueue.poll();
                        if (entry != null) {
                            try {
                                currentLoadPosition = PositionFactory.create((long)entry.getLedgerId(), (long)entry.getEntryId());
                                this.callBack.handleTxnEntry(entry);
                                continue;
                            }
                            finally {
                                entry.release();
                                continue;
                            }
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.closeCursor(SUBSCRIPTION_NAME);
                this.callBack.recoverComplete();
            })).exceptionally(e -> {
                this.callBack.recoverExceptionally(e.getCause());
                log.error("[{}]Transaction buffer failed to recover snapshot!", (Object)this.topic.getName(), e);
                return null;
            });
        }

        private void closeCursor(String subscriptionName) {
            this.topic.getManagedLedger().asyncDeleteCursor(Codec.encode((String)subscriptionName), new AsyncCallbacks.DeleteCursorCallback(){

                public void deleteCursorComplete(Object ctx) {
                    log.info("[{}]Transaction buffer snapshot recover cursor close complete.", (Object)topic.getName());
                }

                public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                    log.error("[{}]Transaction buffer snapshot recover cursor close fail.", (Object)topic.getName());
                }
            }, null);
        }

        private void callBackException(ManagedLedgerException e) {
            log.error("Transaction buffer recover fail when recover transaction entry!", (Throwable)e);
            this.exceptionNumber.getAndIncrement();
        }

        private void closeReader(SystemTopicClient.Reader<TransactionBufferSnapshot> reader) {
            reader.closeAsync().exceptionally(e -> {
                log.error("[{}]Transaction buffer reader close error!", (Object)this.topic.getName(), e);
                return null;
            });
        }
    }

    private record PendingAppendingTxnBufferTask(TxnID txnId, long sequenceId, ByteBuf buffer, CompletableFuture<Position> pendingPublishFuture) {
        void fail(Throwable throwable) {
            this.buffer.release();
            this.pendingPublishFuture.completeExceptionally(throwable);
        }
    }

    static class FillEntryQueueCallback
    implements AsyncCallbacks.ReadEntriesCallback {
        private final AtomicLong outstandingReadsRequests = new AtomicLong(0L);
        private final SpscArrayQueue<Entry> entryQueue;
        private final ManagedCursor cursor;
        private final TopicTransactionBufferRecover recover;
        private volatile boolean isReadable = true;
        private static final int NUMBER_OF_PER_READ_ENTRY = 100;

        private FillEntryQueueCallback(SpscArrayQueue<Entry> entryQueue, ManagedCursor cursor, TopicTransactionBufferRecover recover) {
            this.entryQueue = entryQueue;
            this.cursor = cursor;
            this.recover = recover;
        }

        boolean fillQueue() {
            if (this.entryQueue.size() + 100 < this.entryQueue.capacity() && this.outstandingReadsRequests.get() == 0L) {
                if (this.cursor.hasMoreEntries()) {
                    this.outstandingReadsRequests.incrementAndGet();
                    this.cursor.asyncReadEntries(100, (AsyncCallbacks.ReadEntriesCallback)this, (Object)System.nanoTime(), PositionFactory.LATEST);
                } else if (this.entryQueue.size() == 0) {
                    this.isReadable = false;
                }
            }
            return this.isReadable;
        }

        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.decrementAndGet();
        }

        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            if (this.recover.topic.getManagedLedger().getConfig().isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException || exception instanceof ManagedLedgerException.ManagedLedgerFencedException || exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
                this.isReadable = false;
            } else {
                this.outstandingReadsRequests.decrementAndGet();
            }
            this.recover.callBackException(exception);
        }
    }
}

