/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBufAllocator;
import lombok.Generated;

public final class PooledByteBufAllocatorStats {
    public final long activeAllocations;
    public final long activeAllocationsSmall;
    public final long activeAllocationsNormal;
    public final long activeAllocationsHuge;
    public final long totalAllocated;
    public final long totalUsed;

    public PooledByteBufAllocatorStats(PooledByteBufAllocator allocator) {
        long activeAllocations = 0L;
        long activeAllocationsSmall = 0L;
        long activeAllocationsNormal = 0L;
        long activeAllocationsHuge = 0L;
        long totalAllocated = 0L;
        long totalUsed = 0L;
        for (PoolArenaMetric arena : allocator.metric().directArenas()) {
            activeAllocations += arena.numActiveAllocations();
            activeAllocationsSmall += arena.numActiveSmallAllocations();
            activeAllocationsNormal += arena.numActiveNormalAllocations();
            activeAllocationsHuge += arena.numActiveHugeAllocations();
            for (PoolChunkListMetric list : arena.chunkLists()) {
                for (PoolChunkMetric chunk : list) {
                    int size = chunk.chunkSize();
                    int used = size - chunk.freeBytes();
                    totalAllocated += (long)size;
                    totalUsed += (long)used;
                }
            }
        }
        this.activeAllocations = activeAllocations;
        this.activeAllocationsSmall = activeAllocationsSmall;
        this.activeAllocationsNormal = activeAllocationsNormal;
        this.activeAllocationsHuge = activeAllocationsHuge;
        this.totalAllocated = totalAllocated;
        this.totalUsed = totalUsed;
    }

    @Generated
    public long getActiveAllocations() {
        return this.activeAllocations;
    }

    @Generated
    public long getActiveAllocationsSmall() {
        return this.activeAllocationsSmall;
    }

    @Generated
    public long getActiveAllocationsNormal() {
        return this.activeAllocationsNormal;
    }

    @Generated
    public long getActiveAllocationsHuge() {
        return this.activeAllocationsHuge;
    }

    @Generated
    public long getTotalAllocated() {
        return this.totalAllocated;
    }

    @Generated
    public long getTotalUsed() {
        return this.totalUsed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PooledByteBufAllocatorStats)) {
            return false;
        }
        PooledByteBufAllocatorStats other = (PooledByteBufAllocatorStats)o;
        if (this.getActiveAllocations() != other.getActiveAllocations()) {
            return false;
        }
        if (this.getActiveAllocationsSmall() != other.getActiveAllocationsSmall()) {
            return false;
        }
        if (this.getActiveAllocationsNormal() != other.getActiveAllocationsNormal()) {
            return false;
        }
        if (this.getActiveAllocationsHuge() != other.getActiveAllocationsHuge()) {
            return false;
        }
        if (this.getTotalAllocated() != other.getTotalAllocated()) {
            return false;
        }
        return this.getTotalUsed() == other.getTotalUsed();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $activeAllocations = this.getActiveAllocations();
        result = result * 59 + (int)($activeAllocations >>> 32 ^ $activeAllocations);
        long $activeAllocationsSmall = this.getActiveAllocationsSmall();
        result = result * 59 + (int)($activeAllocationsSmall >>> 32 ^ $activeAllocationsSmall);
        long $activeAllocationsNormal = this.getActiveAllocationsNormal();
        result = result * 59 + (int)($activeAllocationsNormal >>> 32 ^ $activeAllocationsNormal);
        long $activeAllocationsHuge = this.getActiveAllocationsHuge();
        result = result * 59 + (int)($activeAllocationsHuge >>> 32 ^ $activeAllocationsHuge);
        long $totalAllocated = this.getTotalAllocated();
        result = result * 59 + (int)($totalAllocated >>> 32 ^ $totalAllocated);
        long $totalUsed = this.getTotalUsed();
        result = result * 59 + (int)($totalUsed >>> 32 ^ $totalUsed);
        return result;
    }

    @Generated
    public String toString() {
        return "PooledByteBufAllocatorStats(activeAllocations=" + this.getActiveAllocations() + ", activeAllocationsSmall=" + this.getActiveAllocationsSmall() + ", activeAllocationsNormal=" + this.getActiveAllocationsNormal() + ", activeAllocationsHuge=" + this.getActiveAllocationsHuge() + ", totalAllocated=" + this.getTotalAllocated() + ", totalUsed=" + this.getTotalUsed() + ")";
    }
}

