/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations to collect Proxy statistics"})
public class CmdProxyStats
extends CmdBase {
    public void printStats(JsonElement json, boolean indent) throws IOException {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = indent ? builder.setPrettyPrinting().create() : builder.create();
        System.out.println(gson.toJson(json));
    }

    public CmdProxyStats(Supplier<PulsarAdmin> admin) {
        super("proxy-stats", admin);
        this.addCommand("connections", new CmdConnectionMetrics());
        this.addCommand("topics", new CmdTopicsMetrics());
    }

    @CommandLine.Command(description={"dump connections metrics for Monitoring"})
    private class CmdConnectionMetrics
    extends CliCommand {
        @CommandLine.Option(names={"-i", "--indent"}, description={"Indent JSON output"}, required=false)
        private boolean indent = false;

        private CmdConnectionMetrics() {
        }

        @Override
        void run() throws Exception {
            String json = CmdProxyStats.this.getAdmin().proxyStats().getConnections();
            JsonArray stats = (JsonArray)new Gson().fromJson(json, JsonArray.class);
            CmdProxyStats.this.printStats((JsonElement)stats, this.indent);
        }
    }

    @CommandLine.Command(description={"dump topics metrics for Monitoring"})
    private class CmdTopicsMetrics
    extends CliCommand {
        @CommandLine.Option(names={"-i", "--indent"}, description={"Indent JSON output"}, required=false)
        private boolean indent = false;

        private CmdTopicsMetrics() {
        }

        @Override
        void run() throws Exception {
            String json = CmdProxyStats.this.getAdmin().proxyStats().getTopics();
            JsonObject stats = (JsonObject)new Gson().fromJson(json, JsonObject.class);
            CmdProxyStats.this.printStats((JsonElement)stats, this.indent);
        }
    }
}

