/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToMillisConverter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInfo;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations on transactions"})
public class CmdTransactions
extends CmdBase {
    public CmdTransactions(Supplier<PulsarAdmin> admin) {
        super("transactions", admin);
        this.addCommand("coordinator-internal-stats", new GetCoordinatorInternalStats());
        this.addCommand("pending-ack-internal-stats", new GetPendingAckInternalStats());
        this.addCommand("buffer-snapshot-internal-stats", new GetTransactionBufferInternalStats());
        this.addCommand("coordinator-stats", new GetCoordinatorStats());
        this.addCommand("transaction-buffer-stats", new GetTransactionBufferStats());
        this.addCommand("pending-ack-stats", new GetPendingAckStats());
        this.addCommand("transaction-in-buffer-stats", new GetTransactionInBufferStats());
        this.addCommand("transaction-in-pending-ack-stats", new GetTransactionInPendingAckStats());
        this.addCommand("transaction-metadata", new GetTransactionMetadata());
        this.addCommand("slow-transactions", new GetSlowTransactions());
        this.addCommand("scale-transactionCoordinators", new ScaleTransactionCoordinators());
        this.addCommand("position-stats-in-pending-ack", new GetPositionStatsInPendingAck());
        this.addCommand("coordinators-list", new ListTransactionCoordinators());
        this.addCommand("abort-transaction", new AbortTransaction());
    }

    @CommandLine.Command(description={"Get transaction coordinator internal stats"})
    private class GetCoordinatorInternalStats
    extends CliCommand {
        @CommandLine.Option(names={"-c", "--coordinator-id"}, description={"The coordinator id"}, required=true)
        private int coordinatorId;
        @CommandLine.Option(names={"-m", "--metadata"}, description={"Flag to include ledger metadata"})
        private boolean metadata = false;

        private GetCoordinatorInternalStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorInternalStats(this.coordinatorId, this.metadata));
        }
    }

    @CommandLine.Command(description={"Get pending ack internal stats"})
    private class GetPendingAckInternalStats
    extends CliCommand {
        @CommandLine.Option(names={"-t", "--topic"}, description={"Topic name"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-s", "--subscription-name"}, description={"Subscription name"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-m", "--metadata"}, description={"Flag to include ledger metadata"})
        private boolean metadata = false;

        private GetPendingAckInternalStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getPendingAckInternalStats(this.topic, this.subName, this.metadata));
        }
    }

    @CommandLine.Command(description={"Get transaction buffer internal stats"})
    private class GetTransactionBufferInternalStats
    extends CliCommand {
        @CommandLine.Option(names={"-t", "--topic"}, description={"Topic name"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-m", "--metadata"}, description={"Flag to include ledger metadata"})
        private boolean metadata = false;

        private GetTransactionBufferInternalStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionBufferInternalStats(this.topic, this.metadata));
        }
    }

    @CommandLine.Command(description={"Get transaction coordinator stats"})
    private class GetCoordinatorStats
    extends CliCommand {
        @CommandLine.Option(names={"-c", "--coordinator-id"}, description={"The coordinator id"}, required=false)
        private Integer coordinatorId;

        private GetCoordinatorStats() {
        }

        @Override
        void run() throws Exception {
            if (this.coordinatorId != null) {
                this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorStatsById(this.coordinatorId.intValue()));
            } else {
                this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorStats());
            }
        }
    }

    @CommandLine.Command(description={"Get transaction buffer stats"})
    private class GetTransactionBufferStats
    extends CliCommand {
        @CommandLine.Option(names={"-t", "--topic"}, description={"The topic"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-l", "--low-water-mark"}, description={"Whether to get information about lowWaterMarks stored in transaction buffer."})
        private boolean lowWaterMark;
        @CommandLine.Option(names={"-s", "--segment-stats"}, description={"Whether to get segment statistics."})
        private boolean segmentStats = false;

        private GetTransactionBufferStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionBufferStats(this.topic, this.lowWaterMark, this.segmentStats));
        }
    }

    @CommandLine.Command(description={"Get transaction pending ack stats"})
    private class GetPendingAckStats
    extends CliCommand {
        @CommandLine.Option(names={"-t", "--topic"}, description={"The topic name"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-s", "--sub-name"}, description={"The subscription name"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-l", "--low-water-mark"}, description={"Whether to get information about lowWaterMarks stored in transaction pending ack."})
        private boolean lowWaterMarks;

        private GetPendingAckStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getPendingAckStats(this.topic, this.subName, this.lowWaterMarks));
        }
    }

    @CommandLine.Command(description={"Get transaction in buffer stats"})
    private class GetTransactionInBufferStats
    extends CliCommand {
        @CommandLine.Option(names={"-m", "--most-sig-bits"}, description={"The most sig bits"}, required=true)
        private int mostSigBits;
        @CommandLine.Option(names={"-l", "--least-sig-bits"}, description={"The least sig bits"}, required=true)
        private long leastSigBits;
        @CommandLine.Option(names={"-t", "--topic"}, description={"The topic name"}, required=true)
        private String topic;

        private GetTransactionInBufferStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionInBufferStats(new TxnID((long)this.mostSigBits, this.leastSigBits), this.topic));
        }
    }

    @CommandLine.Command(description={"Get transaction in pending ack stats"})
    private class GetTransactionInPendingAckStats
    extends CliCommand {
        @CommandLine.Option(names={"-m", "--most-sig-bits"}, description={"The most sig bits"}, required=true)
        private int mostSigBits;
        @CommandLine.Option(names={"-l", "--least-sig-bits"}, description={"The least sig bits"}, required=true)
        private long leastSigBits;
        @CommandLine.Option(names={"-t", "--topic"}, description={"The topic name"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-s", "--sub-name"}, description={"The subscription name"}, required=true)
        private String subName;

        private GetTransactionInPendingAckStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionInPendingAckStats(new TxnID((long)this.mostSigBits, this.leastSigBits), this.topic, this.subName));
        }
    }

    @CommandLine.Command(description={"Get transaction metadata"})
    private class GetTransactionMetadata
    extends CliCommand {
        @CommandLine.Option(names={"-m", "--most-sig-bits"}, description={"The most sig bits"}, required=true)
        private int mostSigBits;
        @CommandLine.Option(names={"-l", "--least-sig-bits"}, description={"The least sig bits"}, required=true)
        private long leastSigBits;

        private GetTransactionMetadata() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionMetadata(new TxnID((long)this.mostSigBits, this.leastSigBits)));
        }
    }

    @CommandLine.Command(description={"Get slow transactions."})
    private class GetSlowTransactions
    extends CliCommand {
        @CommandLine.Option(names={"-c", "--coordinator-id"}, description={"The coordinator id"}, required=false)
        private Integer coordinatorId;
        @CommandLine.Option(names={"-t", "--time"}, description={"The transaction timeout time. (eg: 1s, 10s, 1m, 5h, 3d)"}, required=true, converter={TimeUnitToMillisConverter.class})
        private Long timeoutInMillis = 1L;

        private GetSlowTransactions() {
        }

        @Override
        void run() throws Exception {
            if (this.coordinatorId != null) {
                this.print(CmdTransactions.this.getAdmin().transactions().getSlowTransactionsByCoordinatorId(this.coordinatorId, this.timeoutInMillis.longValue(), TimeUnit.MILLISECONDS));
            } else {
                this.print(CmdTransactions.this.getAdmin().transactions().getSlowTransactions(this.timeoutInMillis.longValue(), TimeUnit.MILLISECONDS));
            }
        }
    }

    @CommandLine.Command(description={"Update the scale of transaction coordinators"})
    private class ScaleTransactionCoordinators
    extends CliCommand {
        @CommandLine.Option(names={"-r", "--replicas"}, description={"The scale of the transaction coordinators"})
        private int replicas;

        private ScaleTransactionCoordinators() {
        }

        @Override
        void run() throws Exception {
            CmdTransactions.this.getAdmin().transactions().scaleTransactionCoordinators(this.replicas);
        }
    }

    @CommandLine.Command(description={"Get the position stats in transaction pending ack"})
    private class GetPositionStatsInPendingAck
    extends CliCommand {
        @CommandLine.Option(names={"-t", "--topic"}, description={"The topic name"}, required=true)
        private String topic;
        @CommandLine.Option(names={"-s", "--subscription-name"}, description={"Subscription name"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-l", "--ledger-id"}, description={"Ledger ID of the position"}, required=true)
        private Long ledgerId;
        @CommandLine.Option(names={"-e", "--entry-id"}, description={"Entry ID of the position"}, required=true)
        private Long entryId;
        @CommandLine.Option(names={"-b", "--batch-index"}, description={"Batch index of the position"})
        private Integer batchIndex;

        private GetPositionStatsInPendingAck() {
        }

        @Override
        void run() throws Exception {
            CmdTransactions.this.getAdmin().transactions().getPositionStatsInPendingAck(this.topic, this.subName, this.ledgerId, this.entryId, this.batchIndex);
        }
    }

    @CommandLine.Command(description={"List transaction coordinators"})
    private class ListTransactionCoordinators
    extends CliCommand {
        private ListTransactionCoordinators() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().listTransactionCoordinators().stream().collect(Collectors.toMap(TransactionCoordinatorInfo::getId, TransactionCoordinatorInfo::getBrokerServiceUrl)));
        }
    }

    @CommandLine.Command(description={"Abort transaction"})
    private class AbortTransaction
    extends CliCommand {
        @CommandLine.Option(names={"-m", "--most-sig-bits"}, description={"The most sig bits"}, required=true)
        private long mostSigBits;
        @CommandLine.Option(names={"-l", "--least-sig-bits"}, description={"The least sig bits"}, required=true)
        private long leastSigBits;

        private AbortTransaction() {
        }

        @Override
        void run() throws Exception {
            CmdTransactions.this.getAdmin().transactions().abortTransaction(new TxnID(this.mostSigBits, this.leastSigBits));
        }
    }
}

