# PIP-155: Drop support for Python2

Python 2.x has been deprecated for many years now and it was officially end-of-lifed 2.5 years ago (https://www.python.org/doc/sunset-python-2/).

We have well reached the point by which we need to drop Python 2.7 compatibility for Pulsar client and for Pulsar functions.

Based on Python end-of-life policies, there are 4 versions of Python that are currently supported: 3.7, 3.8, 3.9 and 3.10. https://endoflife.date/python

That gives a 5 years support schedule from release to EoL.

## Goal

Support only the last 4 Python releases Pulsar client and for Pulsar functions, currently 3.7, 3.8, 3.9 and 3.10. Once 3.7 reaches end-of-life, it will be dropped by Pulsar too.

This policy will be also applied to the Pulsar patch releases which will stop providing Python wheel files for the deprecated versions.

## API Changes

No changes at this time, though Pulsar Python client library will be now free to use Python3 specific syntaxes and libraries.

## Changes

1. Switch the CI build to run Python client lib tests with Python3
2. Switch integration tests to use Python3
3. Stop building and distributing wheel files for Python 2.7
