/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTopicFunction
implements Function<GenericRecord, byte[]> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeTopicFunction.class);

    public byte[] process(GenericRecord genericRecord, Context context) throws Exception {
        if (context.getCurrentRecord().getMessage().isPresent()) {
            Message msg = (Message)context.getCurrentRecord().getMessage().get();
            if (!msg.getReaderSchema().isPresent()) {
                log.warn("The reader schema is null.");
                return null;
            }
            log.info("process message with reader schema {}", msg.getReaderSchema().get());
            TypedMessageBuilder messageBuilder = context.newOutputMessage(context.getOutputTopic(), Schema.AUTO_PRODUCE_BYTES((Schema)((Schema)msg.getReaderSchema().get())));
            messageBuilder.value((Object)msg.getData()).property("__original_topic", msg.getTopicName()).property("__publish_time", String.valueOf(msg.getPublishTime())).property("__sequence_id", String.valueOf(msg.getSequenceId())).property("__producer_name", msg.getProducerName());
            if (msg.getKeyBytes() != null) {
                messageBuilder.keyBytes(msg.getKeyBytes());
            }
            if (msg.getEventTime() > 0L) {
                messageBuilder.eventTime(msg.getEventTime());
            }
            if (!msg.getProperties().isEmpty()) {
                messageBuilder.properties(msg.getProperties());
            }
            messageBuilder.send();
            log.info("send message successfully");
        } else {
            log.warn("context current record message is not present.");
        }
        return null;
    }
}

