/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import io.netty.util.Timer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TransactionRecoverTracker;
import org.apache.pulsar.transaction.coordinator.TransactionTimeoutTracker;
import org.apache.pulsar.transaction.coordinator.impl.TxnLogBufferedWriterConfig;

@Beta
public interface TransactionMetadataStoreProvider {
    public static TransactionMetadataStoreProvider newProvider(String providerClassName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Object obj = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Preconditions.checkArgument((boolean)(obj instanceof TransactionMetadataStoreProvider), (Object)("The factory has to be an instance of " + TransactionMetadataStoreProvider.class.getName()));
            return (TransactionMetadataStoreProvider)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CompletableFuture<TransactionMetadataStore> openStore(TransactionCoordinatorID var1, ManagedLedgerFactory var2, ManagedLedgerConfig var3, TransactionTimeoutTracker var4, TransactionRecoverTracker var5, long var6, TxnLogBufferedWriterConfig var8, Timer var9);
}

