/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.proxy.socket.client.PerformanceClient;
import org.apache.pulsar.testclient.BrokerMonitor;
import org.apache.pulsar.testclient.CmdBase;
import org.apache.pulsar.testclient.LoadSimulationClient;
import org.apache.pulsar.testclient.LoadSimulationController;
import org.apache.pulsar.testclient.ManagedLedgerWriter;
import org.apache.pulsar.testclient.PerformanceConsumer;
import org.apache.pulsar.testclient.PerformanceProducer;
import org.apache.pulsar.testclient.PerformanceReader;
import org.apache.pulsar.testclient.PerformanceTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="gen-doc", description={"Generate documentation automatically."})
public class CmdGenerateDocumentation
extends CmdBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);
    @CommandLine.Option(names={"-n", "--command-names"}, description={"List of command names"})
    private List<String> commandNames = new ArrayList<String>();
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public CmdGenerateDocumentation() {
        super("gen-doc");
    }

    @Override
    public void run() throws Exception {
        CommandLine commander = this.spec.commandLine();
        LinkedHashMap<String, Class<ManagedLedgerWriter>> cmdClassMap = new LinkedHashMap<String, Class<ManagedLedgerWriter>>();
        cmdClassMap.put("produce", PerformanceProducer.class);
        cmdClassMap.put("consume", PerformanceConsumer.class);
        cmdClassMap.put("transaction", PerformanceTransaction.class);
        cmdClassMap.put("read", PerformanceReader.class);
        cmdClassMap.put("monitor-brokers", BrokerMonitor.class);
        cmdClassMap.put("simulation-client", LoadSimulationClient.class);
        cmdClassMap.put("simulation-controller", LoadSimulationController.class);
        cmdClassMap.put("websocket-producer", PerformanceClient.class);
        cmdClassMap.put("managed-ledger", ManagedLedgerWriter.class);
        for (Map.Entry entry : cmdClassMap.entrySet()) {
            String cmd = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            commander.addSubcommand(cmd, constructor.newInstance(new Object[0]));
        }
        if (this.commandNames.size() == 0) {
            for (Map.Entry entry : commander.getSubcommands().entrySet()) {
                CmdGenerateDocumentation.generateDocument((String)entry.getKey(), commander);
            }
        } else {
            for (String string : this.commandNames) {
                CmdGenerateDocumentation.generateDocument(string, commander);
            }
        }
    }

    private static String generateDocument(String module, CommandLine parentCmd) {
        StringBuilder sb = new StringBuilder();
        CommandLine cmd = (CommandLine)parentCmd.getSubcommands().get(module);
        sb.append("## ").append(module).append("\n\n");
        sb.append(CmdGenerateDocumentation.getCommandDescription(cmd)).append("\n");
        sb.append("\n\n```shell\n").append("$ pulsar-perf ").append(module).append(" [options]").append("\n```");
        sb.append("\n\n");
        sb.append("|Flag|Description|Default|\n");
        sb.append("|---|---|---|\n");
        List options = cmd.getCommandSpec().options();
        options.stream().filter(ele -> !ele.hidden()).forEach(option -> sb.append("| `").append(String.join((CharSequence)", ", option.names())).append("` | ").append(CmdGenerateDocumentation.getOptionDescription(option).replace("\n", " ")).append("|").append(option.defaultValueString()).append("|\n"));
        System.out.println(sb.toString());
        return sb.toString();
    }

    public static String getCommandDescription(CommandLine commandLine) {
        String[] description = commandLine.getCommandSpec().usageMessage().description();
        if (description != null && description.length != 0) {
            return description[0];
        }
        return "";
    }

    public static String getOptionDescription(CommandLine.Model.OptionSpec optionSpec) {
        String[] description = optionSpec.description();
        if (description != null && description.length != 0) {
            return description[0];
        }
        return "";
    }
}

