/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.pulsar.proxy.socket.client.PerformanceClient;
import org.apache.pulsar.testclient.BrokerMonitor;
import org.apache.pulsar.testclient.CmdBase;
import org.apache.pulsar.testclient.CmdGenerateDocumentation;
import org.apache.pulsar.testclient.LoadSimulationClient;
import org.apache.pulsar.testclient.LoadSimulationController;
import org.apache.pulsar.testclient.ManagedLedgerWriter;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PerformanceConsumer;
import org.apache.pulsar.testclient.PerformanceProducer;
import org.apache.pulsar.testclient.PerformanceReader;
import org.apache.pulsar.testclient.PerformanceTransaction;
import org.apache.pulsar.testclient.PulsarPerfTestPropertiesProvider;
import picocli.CommandLine;

@CommandLine.Command(name="pulsar-perf", scope=CommandLine.ScopeType.INHERIT, mixinStandardHelpOptions=true, showDefaultValues=true)
public class PulsarPerfTestTool {
    protected Map<String, Class<?>> commandMap;
    protected final CommandLine commander = new CommandLine((Object)this);

    public PulsarPerfTestTool() {
        this.commandMap = new HashMap();
    }

    private String[] initCommander(String[] args) throws Exception {
        this.commandMap.put("produce", PerformanceProducer.class);
        this.commandMap.put("consume", PerformanceConsumer.class);
        this.commandMap.put("transaction", PerformanceTransaction.class);
        this.commandMap.put("read", PerformanceReader.class);
        this.commandMap.put("monitor-brokers", BrokerMonitor.class);
        this.commandMap.put("simulation-client", LoadSimulationClient.class);
        this.commandMap.put("simulation-controller", LoadSimulationController.class);
        this.commandMap.put("websocket-producer", PerformanceClient.class);
        this.commandMap.put("managed-ledger", ManagedLedgerWriter.class);
        this.commandMap.put("gen-doc", CmdGenerateDocumentation.class);
        if (args.length == 0) {
            System.out.println("Usage: pulsar-perf CONF_FILE_PATH [options] [command] [command options]");
            PerfClientUtils.exit(0);
        }
        String configFile = args[0];
        Properties prop = new Properties(System.getProperties());
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                prop.load(fis);
            }
        }
        this.commander.setDefaultValueProvider((CommandLine.IDefaultValueProvider)PulsarPerfTestPropertiesProvider.create(prop));
        for (Map.Entry<String, Class<?>> c : this.commandMap.entrySet()) {
            Constructor<?> constructor = c.getValue().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.addCommand(c.getKey(), constructor.newInstance(new Object[0]));
        }
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private void addCommand(String name, Object o) {
        if (o instanceof CmdBase) {
            this.commander.addSubcommand(name, (Object)((CmdBase)o).getCommander());
        } else {
            this.commander.addSubcommand(o);
        }
    }

    public static void main(String[] args) throws Exception {
        PulsarPerfTestTool tool = new PulsarPerfTestTool();
        if (tool.run(args = tool.initCommander(args))) {
            PerfClientUtils.exit(0);
        } else {
            PerfClientUtils.exit(1);
        }
    }

    protected boolean run(String[] args) {
        return this.commander.execute(args) == 0;
    }
}

