/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingWriteLacOp;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface ExplicitLacFlushPolicy {
    public static final ExplicitLacFlushPolicy VOID_EXPLICITLAC_FLUSH_POLICY = new ExplicitLacFlushPolicy(){

        @Override
        public void stopExplicitLacFlush() {
        }

        @Override
        public void updatePiggyBackedLac(long piggyBackedLac) {
        }
    };

    public void stopExplicitLacFlush();

    public void updatePiggyBackedLac(long var1);

    public static class ExplicitLacFlushPolicyImpl
    implements ExplicitLacFlushPolicy {
        static final Logger LOG = LoggerFactory.getLogger(ExplicitLacFlushPolicyImpl.class);
        volatile long piggyBackedLac = -1L;
        volatile long explicitLac = -1L;
        final LedgerHandle lh;
        final ClientContext clientCtx;
        ScheduledFuture<?> scheduledFuture;

        ExplicitLacFlushPolicyImpl(LedgerHandle lh, ClientContext clientCtx) {
            this.lh = lh;
            this.clientCtx = clientCtx;
            this.scheduleExplictLacFlush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduled Explicit Last Add Confirmed Update");
            }
        }

        private long getExplicitLac() {
            return this.explicitLac;
        }

        private void setExplicitLac(long explicitLac) {
            this.explicitLac = explicitLac;
        }

        private long getPiggyBackedLac() {
            return this.piggyBackedLac;
        }

        public void setPiggyBackedLac(long piggyBackedLac) {
            this.piggyBackedLac = piggyBackedLac;
        }

        private void scheduleExplictLacFlush() {
            Runnable updateLacTask = new Runnable(){

                @Override
                public void run() {
                    if (this.getExplicitLac() < this.getPiggyBackedLac()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ledgerid: {}", (Object)lh.getId());
                            LOG.debug("explicitLac:{} piggybackLac:{}", (Object)this.getExplicitLac(), (Object)this.getPiggyBackedLac());
                        }
                        this.setExplicitLac(this.getPiggyBackedLac());
                        return;
                    }
                    if (lh.getLastAddConfirmed() > this.getExplicitLac()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ledgerid: {}", (Object)lh.getId());
                        }
                        this.asyncExplicitLacFlush(lh.getLastAddConfirmed());
                        this.setExplicitLac(lh.getLastAddConfirmed());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("After sending explict LAC lac: {}  explicitLac:{}", (Object)lh.getLastAddConfirmed(), (Object)this.getExplicitLac());
                        }
                    }
                }

                public String toString() {
                    return String.format("UpdateLacTask ledgerId - (%d)", lh.getId());
                }
            };
            try {
                long explicitLacIntervalInMs = this.clientCtx.getConf().explicitLacInterval;
                this.scheduledFuture = this.clientCtx.getScheduler().scheduleAtFixedRateOrdered((Object)this.lh.getId(), updateLacTask, explicitLacIntervalInMs, explicitLacIntervalInMs, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException re) {
                LOG.error("Scheduling of ExplictLastAddConfirmedFlush for ledger: {} has failed.", (Object)this.lh.getId(), (Object)re);
            }
        }

        void asyncExplicitLacFlush(long explicitLac) {
            SyncCallbackUtils.LastAddConfirmedCallback cb = SyncCallbackUtils.LastAddConfirmedCallback.INSTANCE;
            PendingWriteLacOp op = new PendingWriteLacOp(this.lh, this.clientCtx, this.lh.getCurrentEnsemble(), cb, null);
            op.setLac(explicitLac);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending Explicit LAC: {}", (Object)explicitLac);
                }
                this.clientCtx.getMainWorkerPool().submit(() -> {
                    ByteBufList toSend = this.lh.macManager.computeDigestAndPackageForSendingLac(this.lh.getLastAddConfirmed());
                    op.initiate(toSend);
                });
            }
            catch (RejectedExecutionException e) {
                cb.addLacComplete(BookKeeper.getReturnRc(this.clientCtx.getBookieClient(), -15), this.lh, null);
            }
        }

        @Override
        public void stopExplicitLacFlush() {
            this.scheduledFuture.cancel(true);
        }

        @Override
        public void updatePiggyBackedLac(long piggyBackedLac) {
            this.setPiggyBackedLac(piggyBackedLac);
        }
    }
}

