/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.resources.MetadataStoreCacheLoader;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.ServiceLookupData;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public class BrokerDiscoveryProvider
implements Closeable {
    final MetadataStoreCacheLoader metadataStoreCacheLoader;
    final PulsarResources pulsarResources;
    private final AtomicInteger counter = new AtomicInteger();
    private final OrderedScheduler orderedExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(4).name("pulsar-proxy-ordered").build();
    private final ScheduledExecutorService scheduledExecutorScheduler = Executors.newScheduledThreadPool(4, (ThreadFactory)new DefaultThreadFactory("pulsar-proxy-scheduled-executor"));
    private static final Logger LOG = LoggerFactory.getLogger(BrokerDiscoveryProvider.class);

    public BrokerDiscoveryProvider(ProxyConfiguration config, PulsarResources pulsarResources) throws PulsarServerException {
        try {
            this.pulsarResources = pulsarResources;
            this.metadataStoreCacheLoader = new MetadataStoreCacheLoader(pulsarResources, config.getMetadataStoreSessionTimeoutMillis());
        }
        catch (Exception e) {
            LOG.error("Failed to start ZooKeeper {}", (Object)e.getMessage(), (Object)e);
            throw new PulsarServerException("Failed to start zookeeper :" + e.getMessage(), (Throwable)e);
        }
    }

    public List<? extends ServiceLookupData> getAvailableBrokers() throws PulsarServerException {
        return this.metadataStoreCacheLoader.getAvailableBrokers();
    }

    LoadManagerReport nextBroker() throws PulsarServerException {
        List availableBrokers = this.metadataStoreCacheLoader.getAvailableBrokers();
        if (availableBrokers.isEmpty()) {
            throw new PulsarServerException("No active broker is available");
        }
        int brokersCount = availableBrokers.size();
        int nextIdx = MathUtils.signSafeMod((long)this.counter.getAndIncrement(), (int)brokersCount);
        return (LoadManagerReport)availableBrokers.get(nextIdx);
    }

    @Override
    public void close() throws IOException {
        this.metadataStoreCacheLoader.close();
        this.orderedExecutor.shutdown();
        this.scheduledExecutorScheduler.shutdownNow();
    }
}

