/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PortworxVolumeSource represents a Portworx volume resource.")
public class V1PortworxVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_VOLUME_I_D = "volumeID";
    @SerializedName(value="volumeID")
    private String volumeID;

    public V1PortworxVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1PortworxVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1PortworxVolumeSource volumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @ApiModelProperty(required=true, value="volumeID uniquely identifies a Portworx volume")
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PortworxVolumeSource v1PortworxVolumeSource = (V1PortworxVolumeSource)o;
        return Objects.equals(this.fsType, v1PortworxVolumeSource.fsType) && Objects.equals(this.readOnly, v1PortworxVolumeSource.readOnly) && Objects.equals(this.volumeID, v1PortworxVolumeSource.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PortworxVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

