/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtocolHandlerWithClassLoader
implements ProtocolHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolHandlerWithClassLoader.class);
    private final ProtocolHandler handler;
    private final NarClassLoader classLoader;

    @Override
    public String protocolName() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            String string = this.handler.protocolName();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(String protocol) {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            boolean bl = this.handler.accept(protocol);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public void initialize(ServiceConfiguration conf) throws Exception {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            this.handler.initialize(conf);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public String getProtocolDataToAdvertise() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            String string = this.handler.getProtocolDataToAdvertise();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public void start(BrokerService service) {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            this.handler.start(service);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            Map<InetSocketAddress, ChannelInitializer<SocketChannel>> map = this.handler.newChannelInitializers();
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public void close() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            this.handler.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the protocol handler class loader", (Throwable)e);
        }
    }

    @Generated
    public ProtocolHandler getHandler() {
        return this.handler;
    }

    @Generated
    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolHandlerWithClassLoader)) {
            return false;
        }
        ProtocolHandlerWithClassLoader other = (ProtocolHandlerWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProtocolHandler this$handler = this.getHandler();
        ProtocolHandler other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtocolHandlerWithClassLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProtocolHandlerWithClassLoader(handler=" + String.valueOf(this.getHandler()) + ", classLoader=" + String.valueOf(this.getClassLoader()) + ")";
    }

    @Generated
    public ProtocolHandlerWithClassLoader(ProtocolHandler handler, NarClassLoader classLoader) {
        this.handler = handler;
        this.classLoader = classLoader;
    }
}

