/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.EntryBatchIndexesAcks;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.PulsarCommandSender;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandLookupTopicResponse;
import org.apache.pulsar.common.api.proto.CommandTopicMigrated;
import org.apache.pulsar.common.api.proto.ProtocolVersion;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiter;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiterUtil;
import org.apache.pulsar.common.util.netty.NettyChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarCommandSenderImpl
implements PulsarCommandSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarCommandSenderImpl.class);
    private final BrokerInterceptor interceptor;
    private final ServerCnx cnx;
    private final AsyncDualMemoryLimiter maxTopicListInFlightLimiter;

    public PulsarCommandSenderImpl(BrokerInterceptor interceptor, ServerCnx cnx, AsyncDualMemoryLimiter maxTopicListInFlightLimiter) {
        this.interceptor = interceptor;
        this.cnx = cnx;
        this.maxTopicListInFlightLimiter = maxTopicListInFlightLimiter;
    }

    @Override
    public void sendPartitionMetadataResponse(ServerError error, String errorMsg, long requestId) {
        BaseCommand command = Commands.newPartitionMetadataResponseCommand((ServerError)error, (String)errorMsg, (long)requestId);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendPartitionMetadataResponse(int partitions, long requestId) {
        BaseCommand command = Commands.newPartitionMetadataResponseCommand((int)partitions, (long)requestId);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendSuccessResponse(long requestId) {
        BaseCommand command = Commands.newSuccessCommand((long)requestId);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendErrorResponse(long requestId, ServerError error, String message) {
        BaseCommand command = Commands.newErrorCommand((long)requestId, (ServerError)error, (String)message);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendProducerSuccessResponse(long requestId, String producerName, SchemaVersion schemaVersion) {
        BaseCommand command = Commands.newProducerSuccessCommand((long)requestId, (String)producerName, (SchemaVersion)schemaVersion);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendProducerSuccessResponse(long requestId, String producerName, long lastSequenceId, SchemaVersion schemaVersion, Optional<Long> topicEpoch, boolean isProducerReady) {
        BaseCommand command = Commands.newProducerSuccessCommand((long)requestId, (String)producerName, (long)lastSequenceId, (SchemaVersion)schemaVersion, topicEpoch, (boolean)isProducerReady);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendSendReceiptResponse(long producerId, long sequenceId, long highestId, long ledgerId, long entryId) {
        BaseCommand command = Commands.newSendReceiptCommand((long)producerId, (long)sequenceId, (long)highestId, (long)ledgerId, (long)entryId);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendSendError(long producerId, long sequenceId, ServerError error, String errorMsg) {
        BaseCommand command = Commands.newSendErrorCommand((long)producerId, (long)sequenceId, (ServerError)error, (String)errorMsg);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public CompletableFuture<Void> sendGetTopicsOfNamespaceResponse(List<String> topics, String topicsHash, boolean filtered, boolean changed, long requestId, Consumer<Throwable> permitAcquireErrorHandler) {
        BaseCommand command = Commands.newGetTopicsOfNamespaceResponseCommand(topics, (String)topicsHash, (boolean)filtered, (boolean)changed, (long)requestId);
        this.safeIntercept(command, this.cnx);
        return AsyncDualMemoryLimiterUtil.acquireDirectMemoryPermitsAndWriteAndFlush((ChannelHandlerContext)this.cnx.ctx(), (AsyncDualMemoryLimiter)this.maxTopicListInFlightLimiter, () -> !this.cnx.isActive(), (BaseCommand)command, permitAcquireErrorHandler);
    }

    @Override
    public void sendGetSchemaResponse(long requestId, SchemaInfo schema, SchemaVersion version) {
        BaseCommand command = Commands.newGetSchemaResponseCommand((long)requestId, (SchemaInfo)schema, (SchemaVersion)version);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendGetSchemaErrorResponse(long requestId, ServerError error, String errorMessage) {
        BaseCommand command = Commands.newGetSchemaResponseErrorCommand((long)requestId, (ServerError)error, (String)errorMessage);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendGetOrCreateSchemaResponse(long requestId, SchemaVersion schemaVersion) {
        BaseCommand command = Commands.newGetOrCreateSchemaResponseCommand((long)requestId, (SchemaVersion)schemaVersion);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendGetOrCreateSchemaErrorResponse(long requestId, ServerError error, String errorMessage) {
        BaseCommand command = Commands.newGetOrCreateSchemaResponseErrorCommand((long)requestId, (ServerError)error, (String)errorMessage);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendConnectedResponse(int clientProtocolVersion, int maxMessageSize, boolean supportsTopicWatchers) {
        BaseCommand command = Commands.newConnectedCommand((int)clientProtocolVersion, (int)maxMessageSize, (boolean)supportsTopicWatchers);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendLookupResponse(String brokerServiceUrl, String brokerServiceUrlTls, boolean authoritative, CommandLookupTopicResponse.LookupType response, long requestId, boolean proxyThroughServiceUrl) {
        BaseCommand command = Commands.newLookupResponseCommand((String)brokerServiceUrl, (String)brokerServiceUrlTls, (boolean)authoritative, (CommandLookupTopicResponse.LookupType)response, (long)requestId, (boolean)proxyThroughServiceUrl);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendLookupResponse(ServerError error, String errorMsg, long requestId) {
        BaseCommand command = Commands.newLookupErrorResponseCommand((ServerError)error, (String)errorMsg, (long)requestId);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendActiveConsumerChange(long consumerId, boolean isActive) {
        if (!Commands.peerSupportsActiveConsumerListener((int)this.cnx.getRemoteEndpointProtocolVersion())) {
            return;
        }
        this.writeAndFlush(Commands.newActiveConsumerChange((long)consumerId, (boolean)isActive));
    }

    @Override
    public void sendReachedEndOfTopic(long consumerId) {
        if (this.cnx.getRemoteEndpointProtocolVersion() >= ProtocolVersion.v9.getValue()) {
            log.info("[{}] Notifying consumer that end of topic has been reached", (Object)this);
            this.writeAndFlush(Commands.newReachedEndOfTopic((long)consumerId));
        }
    }

    @Override
    public boolean sendTopicMigrated(CommandTopicMigrated.ResourceType type, long resourceId, String brokerUrl, String brokerUrlTls) {
        if (this.cnx.getRemoteEndpointProtocolVersion() >= ProtocolVersion.v20.getValue()) {
            log.info("[{}] Notifying {} that topic is migrated", (Object)type.name(), (Object)resourceId);
            this.writeAndFlush(Commands.newTopicMigrated((CommandTopicMigrated.ResourceType)type, (long)resourceId, (String)brokerUrl, (String)brokerUrlTls));
            return true;
        }
        return false;
    }

    public ChannelPromise sendMessagesToConsumer(long consumerId, String topicName, Subscription subscription, int partitionIdx, List<? extends Entry> entries, EntryBatchSizes batchSizes, EntryBatchIndexesAcks batchIndexesAcks, RedeliveryTracker redeliveryTracker, long epoch) {
        ChannelHandlerContext ctx = this.cnx.ctx();
        ChannelPromise writePromise = ctx.newPromise();
        ctx.channel().eventLoop().execute(() -> {
            ArrayList<Entry> entriesToRelease = new ArrayList<Entry>(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                if (entry == null) continue;
                int batchSize = batchSizes.getBatchSize(i);
                if (batchSize > 1 && !this.cnx.isBatchMessageCompatibleVersion()) {
                    log.warn("[{}-{}] Consumer doesn't support batch messages -  consumerId {}, msg id {}-{}", new Object[]{topicName, subscription, consumerId, entry.getLedgerId(), entry.getEntryId()});
                    ctx.close();
                    entry.release();
                    continue;
                }
                ByteBuf metadataAndPayload = entry.getDataBuffer();
                metadataAndPayload.retain();
                if (this.cnx.getRemoteEndpointProtocolVersion() < ProtocolVersion.v18.getValue() || !this.cnx.supportBrokerMetadata() || !this.cnx.getBrokerService().getPulsar().getConfig().isExposingBrokerEntryMetadataToClientEnabled()) {
                    Commands.skipBrokerEntryMetadataIfExist((ByteBuf)metadataAndPayload);
                }
                if (this.cnx.getRemoteEndpointProtocolVersion() < ProtocolVersion.v11.getValue()) {
                    Commands.skipChecksumIfPresent((ByteBuf)metadataAndPayload);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}-{}] Sending message to consumerId {}, msg id {}-{} with batchSize {}", new Object[]{topicName, subscription, consumerId, entry.getLedgerId(), entry.getEntryId(), batchSize});
                }
                int redeliveryCount = redeliveryTracker.getRedeliveryCount(entry.getLedgerId(), entry.getEntryId());
                ctx.write((Object)this.cnx.newMessageAndIntercept(consumerId, entry.getLedgerId(), entry.getEntryId(), partitionIdx, redeliveryCount, metadataAndPayload, batchIndexesAcks == null ? null : batchIndexesAcks.getAckSet(i), topicName, epoch), ctx.voidPromise());
                entriesToRelease.add(entry);
            }
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER, writePromise);
            writePromise.addListener(future -> entriesToRelease.forEach(Entry::release));
            batchSizes.recyle();
            if (batchIndexesAcks != null) {
                batchIndexesAcks.recycle();
            }
        });
        return writePromise;
    }

    @Override
    public void sendTcClientConnectResponse(long requestId, ServerError error, String message) {
        BaseCommand command = Commands.newTcClientConnectResponse((long)requestId, (ServerError)error, (String)message);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendTcClientConnectResponse(long requestId) {
        this.sendTcClientConnectResponse(requestId, null, null);
    }

    @Override
    public void sendNewTxnResponse(long requestId, TxnID txnID, long tcID) {
        BaseCommand command = Commands.newTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits());
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
        if (this.interceptor != null) {
            this.interceptor.txnOpened(tcID, txnID.toString());
        }
    }

    @Override
    public void sendNewTxnErrorResponse(long requestId, long tcID, ServerError error, String message) {
        BaseCommand command = Commands.newTxnResponse((long)requestId, (long)tcID, (ServerError)error, (String)message);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendEndTxnResponse(long requestId, TxnID txnID, int txnAction) {
        BaseCommand command = Commands.newEndTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits());
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
        if (this.interceptor != null) {
            this.interceptor.txnEnded(txnID.toString(), txnAction);
        }
    }

    @Override
    public void sendEndTxnErrorResponse(long requestId, TxnID txnID, ServerError error, String message) {
        BaseCommand command = Commands.newEndTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (ServerError)error, (String)message);
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    @Override
    public void sendWatchTopicListSuccess(long requestId, long watcherId, String topicsHash, List<String> topics) {
        BaseCommand command = Commands.newWatchTopicListSuccess((long)requestId, (long)watcherId, (String)topicsHash, topics);
        this.interceptAndWriteCommand(command);
    }

    @Override
    public void sendWatchTopicListUpdate(long watcherId, List<String> newTopics, List<String> deletedTopics, String topicsHash) {
        BaseCommand command = Commands.newWatchTopicUpdate((long)watcherId, newTopics, deletedTopics, (String)topicsHash);
        this.interceptAndWriteCommand(command);
    }

    private void interceptAndWriteCommand(BaseCommand command) {
        this.safeIntercept(command, this.cnx);
        ByteBuf outBuf = Commands.serializeWithSize((BaseCommand)command);
        this.writeAndFlush(outBuf);
    }

    private void writeAndFlush(ByteBuf outBuf) {
        NettyChannelUtil.writeAndFlushWithVoidPromise((ChannelOutboundInvoker)this.cnx.ctx(), (ByteBuf)outBuf);
    }

    private void safeIntercept(BaseCommand command, ServerCnx cnx) {
        if (this.interceptor != null) {
            try {
                this.interceptor.onPulsarCommand(command, cnx);
            }
            catch (Exception e) {
                log.error("Failed to execute command {} on broker interceptor.", (Object)command.getType(), (Object)e);
            }
        }
    }
}

