/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.SystemTopicTxnBufferSnapshotService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.transaction.buffer.AbortedTxnProcessor;
import org.apache.pulsar.broker.transaction.buffer.metadata.AbortTxnMetadata;
import org.apache.pulsar.broker.transaction.buffer.metadata.TransactionBufferSnapshot;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSnapshotAbortedTxnProcessorImpl
implements AbortedTxnProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleSnapshotAbortedTxnProcessorImpl.class);
    private final PersistentTopic topic;
    private final SystemTopicTxnBufferSnapshotService.ReferenceCountedWriter<TransactionBufferSnapshot> takeSnapshotWriter;
    private final LinkedMap<TxnID, Position> aborts = new LinkedMap();
    private volatile long lastSnapshotTimestamps;
    private volatile boolean isClosed = false;

    public SingleSnapshotAbortedTxnProcessorImpl(PersistentTopic topic) {
        this.topic = topic;
        this.takeSnapshotWriter = this.topic.getBrokerService().getPulsar().getTransactionBufferSnapshotServiceFactory().getTxnBufferSnapshotService().getReferenceWriter(TopicName.get((String)topic.getName()).getNamespaceObject());
        this.takeSnapshotWriter.getFuture().exceptionally(ex -> {
            log.error("{} Failed to create snapshot writer", (Object)topic.getName());
            topic.close();
            return null;
        });
    }

    @Override
    public void putAbortedTxnAndPosition(TxnID abortedTxnId, Position abortedMarkerPersistentPosition) {
        this.aborts.put((Object)abortedTxnId, (Object)abortedMarkerPersistentPosition);
    }

    @Override
    public void trimExpiredAbortedTxns() {
        while (!this.aborts.isEmpty() && !this.topic.getManagedLedger().getLedgersInfo().containsKey(((Position)this.aborts.get(this.aborts.firstKey())).getLedgerId())) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Topic transaction buffer clear aborted transaction, TxnId : {}, Position : {}", new Object[]{this.topic.getName(), this.aborts.firstKey(), this.aborts.get(this.aborts.firstKey())});
            }
            this.aborts.remove(this.aborts.firstKey());
        }
    }

    @Override
    public boolean checkAbortedTransaction(TxnID txnID) {
        return this.aborts.containsKey((Object)txnID);
    }

    @Override
    public CompletableFuture<Position> recoverFromSnapshot() {
        CompletableFuture<Position> future = new CompletableFuture<Position>();
        PulsarService pulsar = this.topic.getBrokerService().getPulsar();
        pulsar.getTransactionSnapshotRecoverExecutorProvider().getExecutor((Object)this).execute(() -> {
            try {
                TransactionBufferSnapshot snapshot = pulsar.getTransactionBufferSnapshotServiceFactory().getTxnBufferSnapshotService().getTableView().readLatest(this.topic.getName());
                if (snapshot != null) {
                    this.handleSnapshot(snapshot);
                    Position startReadCursorPosition = PositionFactory.create((long)snapshot.getMaxReadPositionLedgerId(), (long)snapshot.getMaxReadPositionEntryId());
                    future.complete(startReadCursorPosition);
                } else {
                    future.complete(null);
                }
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> clearAbortedTxnSnapshot() {
        NamespaceName namespaceName = TopicName.get((String)this.topic.getName()).getNamespaceObject();
        PulsarService pulsar = this.topic.getBrokerService().getPulsar();
        return NamespaceEventsSystemTopicFactory.checkSystemTopicExists(namespaceName, EventType.TRANSACTION_BUFFER_SNAPSHOT, pulsar).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return ((CompletableFuture)this.takeSnapshotWriter.getFuture().thenCompose(writer -> {
                    TransactionBufferSnapshot snapshot = new TransactionBufferSnapshot();
                    snapshot.setTopicName(this.topic.getName());
                    return writer.deleteAsync(snapshot.getTopicName(), snapshot);
                })).thenRun(() -> log.info("[{}] Successes to delete the aborted transaction snapshot", (Object)this.topic));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> takeAbortedTxnsSnapshot(Position maxReadPosition) {
        return this.takeSnapshotWriter.getFuture().thenCompose(writer -> {
            TransactionBufferSnapshot snapshot = new TransactionBufferSnapshot();
            snapshot.setTopicName(this.topic.getName());
            snapshot.setMaxReadPositionLedgerId(maxReadPosition.getLedgerId());
            snapshot.setMaxReadPositionEntryId(maxReadPosition.getEntryId());
            ArrayList<AbortTxnMetadata> list = new ArrayList<AbortTxnMetadata>();
            this.aborts.forEach((k, v) -> {
                AbortTxnMetadata abortTxnMetadata = new AbortTxnMetadata();
                abortTxnMetadata.setTxnIdMostBits(k.getMostSigBits());
                abortTxnMetadata.setTxnIdLeastBits(k.getLeastSigBits());
                abortTxnMetadata.setLedgerId(v.getLedgerId());
                abortTxnMetadata.setEntryId(v.getEntryId());
                list.add(abortTxnMetadata);
            });
            snapshot.setAborts(list);
            return ((CompletableFuture)writer.writeAsync(snapshot.getTopicName(), snapshot).thenAccept(messageId -> {
                this.lastSnapshotTimestamps = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug("[{}]Transaction buffer take snapshot success! messageId : {}", (Object)this.topic.getName(), messageId);
                }
            })).exceptionally(e -> {
                log.warn("[{}]Transaction buffer take snapshot fail! ", (Object)this.topic.getName(), (Object)e.getCause());
                return null;
            });
        });
    }

    @Override
    public TransactionBufferStats generateSnapshotStats(boolean segmentStats) {
        TransactionBufferStats transactionBufferStats = new TransactionBufferStats();
        transactionBufferStats.lastSnapshotTimestamps = this.lastSnapshotTimestamps;
        transactionBufferStats.totalAbortedTransactions = this.aborts.size();
        return transactionBufferStats;
    }

    @Override
    public synchronized CompletableFuture<Void> closeAsync() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.takeSnapshotWriter.release();
        }
        return CompletableFuture.completedFuture(null);
    }

    private void handleSnapshot(TransactionBufferSnapshot snapshot) {
        if (snapshot.getAborts() != null) {
            snapshot.getAborts().forEach(abortTxnMetadata -> this.aborts.put((Object)new TxnID(abortTxnMetadata.getTxnIdMostBits(), abortTxnMetadata.getTxnIdLeastBits()), (Object)PositionFactory.create((long)abortTxnMetadata.getLedgerId(), (long)abortTxnMetadata.getEntryId())));
        }
    }
}

