/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.concurrent;

import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.util.Permit;

public class AsyncSemaphore {
    private final Optional<Integer> maxWaiters;
    private final Permit semaphorePermit = new Permit(){

        @Override
        public void release() {
            AsyncSemaphore.this.releasePermit(this);
        }
    };
    @GuardedBy(value="this")
    private Optional<Throwable> closed = Optional.empty();
    @GuardedBy(value="this")
    private final LinkedList<CompletableFuture<Permit>> waitq;
    @GuardedBy(value="this")
    private int availablePermits;

    public AsyncSemaphore(int initialPermits, Optional<Integer> maxWaiters) {
        this.availablePermits = initialPermits;
        this.waitq = new LinkedList();
        this.maxWaiters = maxWaiters;
    }

    private synchronized void releasePermit(Permit permit) {
        CompletableFuture<Permit> next = this.waitq.pollFirst();
        if (null != next) {
            next.complete(permit);
        } else {
            ++this.availablePermits;
        }
    }

    private CompletableFuture<Permit> newFuturePermit() {
        return FutureUtils.value((Object)this.semaphorePermit);
    }

    public synchronized CompletableFuture<Permit> acquire() {
        if (this.closed.isPresent()) {
            return FutureUtils.exception((Throwable)this.closed.get());
        }
        if (this.availablePermits > 0) {
            --this.availablePermits;
            return this.newFuturePermit();
        }
        if (this.maxWaiters.isPresent() && this.waitq.size() >= this.maxWaiters.get()) {
            return FutureUtils.exception((Throwable)new RejectedExecutionException("Max waiters exceeded"));
        }
        CompletableFuture future = FutureUtils.createFuture();
        future.whenComplete((value, cause) -> {
            AsyncSemaphore asyncSemaphore = this;
            synchronized (asyncSemaphore) {
                this.waitq.remove(future);
            }
        });
        this.waitq.addLast(future);
        return future;
    }

    public synchronized void fail(Throwable exc) {
        this.closed = Optional.of(exc);
        for (CompletableFuture completableFuture : this.waitq) {
            completableFuture.cancel(true);
        }
        this.waitq.clear();
    }

    public <T> CompletableFuture<T> acquireAndRun(Supplier<CompletableFuture<T>> func) {
        return this.acquire().thenCompose(permit -> {
            try {
                CompletableFuture future = (CompletableFuture)func.get();
                future.whenComplete((value, cause) -> permit.release());
                return future;
            }
            catch (Throwable cause2) {
                permit.release();
                throw cause2;
            }
        });
    }
}

