/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import lombok.Generated;
import org.apache.bookkeeper.mledger.EntryReadCountHandler;

public class EntryReadCountHandlerImpl
implements EntryReadCountHandler {
    private static final AtomicIntegerFieldUpdater<EntryReadCountHandlerImpl> EXPECTED_READ_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(EntryReadCountHandlerImpl.class, "expectedReadCount");
    private volatile int expectedReadCount;

    private EntryReadCountHandlerImpl(int expectedReadCount) {
        this.expectedReadCount = expectedReadCount;
    }

    @Override
    public int getExpectedReadCount() {
        return this.expectedReadCount;
    }

    @Override
    public void incrementExpectedReadCount() {
        EXPECTED_READ_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public void markRead() {
        EXPECTED_READ_COUNT_UPDATER.decrementAndGet(this);
    }

    public static EntryReadCountHandlerImpl maybeCreate(int expectedReadCount) {
        return expectedReadCount > 0 ? new EntryReadCountHandlerImpl(expectedReadCount) : null;
    }

    @VisibleForTesting
    public void setExpectedReadCount(int expectedReadCount) {
        this.expectedReadCount = expectedReadCount;
    }

    @Generated
    public String toString() {
        return "EntryReadCountHandlerImpl(expectedReadCount=" + this.getExpectedReadCount() + ")";
    }
}

