/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus;

import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.DataObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.json.annotations.JsonGen;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.MessageConsumerOptionsConverter;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.Arguments;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;

@DataObject
@JsonGen(publicConverter=false)
public class MessageConsumerOptions {
    public static final int DEFAULT_MAX_BUFFERED_MESSAGES = 1000;
    public static final boolean DEFAULT_LOCAL_ONLY = false;
    private String address;
    private boolean localOnly = false;
    private int maxBufferedMessages = 1000;

    public MessageConsumerOptions() {
    }

    public MessageConsumerOptions(MessageConsumerOptions options) {
        this();
        this.maxBufferedMessages = options.getMaxBufferedMessages();
        this.localOnly = options.isLocalOnly();
        this.address = options.getAddress();
    }

    public MessageConsumerOptions(JsonObject json) {
        this();
        MessageConsumerOptionsConverter.fromJson(json, this);
    }

    public String getAddress() {
        return this.address;
    }

    public MessageConsumerOptions setAddress(String address) {
        this.address = address;
        return this;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public MessageConsumerOptions setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
        return this;
    }

    public int getMaxBufferedMessages() {
        return this.maxBufferedMessages;
    }

    public MessageConsumerOptions setMaxBufferedMessages(int maxBufferedMessages) {
        Arguments.require(maxBufferedMessages >= 0, "Max buffered messages cannot be negative");
        this.maxBufferedMessages = maxBufferedMessages;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        MessageConsumerOptionsConverter.toJson(this, json);
        return json;
    }
}

