/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.metadata.FileSegmentMetadata;
import org.apache.rocketmq.tieredstore.metadata.QueueMetadata;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataSerializeWrapper;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.metadata.TopicMetadata;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;

public class TieredMetadataManager
extends ConfigManager
implements TieredMetadataStore {
    private final AtomicInteger maxTopicId = new AtomicInteger(0);
    private final ConcurrentMap<String, TopicMetadata> topicMetadataTable = new ConcurrentHashMap<String, TopicMetadata>(1024);
    private final ConcurrentMap<String, ConcurrentMap<Integer, QueueMetadata>> queueMetadataTable = new ConcurrentHashMap<String, ConcurrentMap<Integer, QueueMetadata>>(1024);
    private final ConcurrentMap<MessageQueue, ConcurrentMap<Long, FileSegmentMetadata>> commitLogFileSegmentTable = new ConcurrentHashMap<MessageQueue, ConcurrentMap<Long, FileSegmentMetadata>>(1024);
    private final ConcurrentMap<MessageQueue, ConcurrentMap<Long, FileSegmentMetadata>> consumeQueueFileSegmentTable = new ConcurrentHashMap<MessageQueue, ConcurrentMap<Long, FileSegmentMetadata>>(1024);
    private final ConcurrentMap<MessageQueue, ConcurrentMap<Long, FileSegmentMetadata>> indexFileSegmentTable = new ConcurrentHashMap<MessageQueue, ConcurrentMap<Long, FileSegmentMetadata>>(1024);
    private final TieredMessageStoreConfig storeConfig;

    public TieredMetadataManager(TieredMessageStoreConfig storeConfig) {
        this.storeConfig = storeConfig;
        this.load();
    }

    public String encode() {
        return this.encode(false);
    }

    public String encode(boolean prettyFormat) {
        TieredMetadataSerializeWrapper dataWrapper = new TieredMetadataSerializeWrapper();
        dataWrapper.setMaxTopicId(this.maxTopicId);
        dataWrapper.setTopicMetadataTable(this.topicMetadataTable);
        dataWrapper.setQueueMetadataTable(new HashMap<String, Map<Integer, QueueMetadata>>(this.queueMetadataTable));
        dataWrapper.setCommitLogFileSegmentTable(new HashMap<MessageQueue, Map<Long, FileSegmentMetadata>>(this.commitLogFileSegmentTable));
        dataWrapper.setConsumeQueueFileSegmentTable(new HashMap<MessageQueue, Map<Long, FileSegmentMetadata>>(this.consumeQueueFileSegmentTable));
        dataWrapper.setIndexFileSegmentTable(new HashMap<MessageQueue, Map<Long, FileSegmentMetadata>>(this.indexFileSegmentTable));
        if (prettyFormat) {
            JSON.toJSONString((Object)((Object)dataWrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)((Object)dataWrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public String configFilePath() {
        return this.storeConfig.getStorePathRootDir() + File.separator + "config" + File.separator + "tieredStoreMetadata.json";
    }

    public void decode(String jsonString) {
        TieredMetadataSerializeWrapper dataWrapper;
        if (jsonString != null && (dataWrapper = (TieredMetadataSerializeWrapper)((Object)TieredMetadataSerializeWrapper.fromJson((String)jsonString, TieredMetadataSerializeWrapper.class))) != null) {
            this.maxTopicId.set(dataWrapper.getMaxTopicId().get());
            this.topicMetadataTable.putAll(dataWrapper.getTopicMetadataTable());
            dataWrapper.getQueueMetadataTable().forEach((topic, map) -> {
                ConcurrentMap cfr_ignored_0 = this.queueMetadataTable.put((String)topic, new ConcurrentHashMap(map));
            });
            dataWrapper.getCommitLogFileSegmentTable().forEach((mq, map) -> {
                ConcurrentMap cfr_ignored_0 = this.commitLogFileSegmentTable.put((MessageQueue)mq, new ConcurrentHashMap(map));
            });
            dataWrapper.getConsumeQueueFileSegmentTable().forEach((mq, map) -> {
                ConcurrentMap cfr_ignored_0 = this.consumeQueueFileSegmentTable.put((MessageQueue)mq, new ConcurrentHashMap(map));
            });
            dataWrapper.getIndexFileSegmentTable().forEach((mq, map) -> {
                ConcurrentMap cfr_ignored_0 = this.indexFileSegmentTable.put((MessageQueue)mq, new ConcurrentHashMap(map));
            });
        }
    }

    @Override
    public void setMaxTopicId(int maxTopicId) {
        this.maxTopicId.set(maxTopicId);
    }

    @Override
    @Nullable
    public TopicMetadata getTopic(String topic) {
        return (TopicMetadata)this.topicMetadataTable.get(topic);
    }

    @Override
    public void iterateTopic(Consumer<TopicMetadata> callback) {
        this.topicMetadataTable.values().forEach(callback);
    }

    @Override
    public TopicMetadata addTopic(String topic, long reserveTime) {
        TopicMetadata old = this.getTopic(topic);
        if (old != null) {
            return old;
        }
        TopicMetadata metadata = new TopicMetadata(this.maxTopicId.getAndIncrement(), topic, reserveTime);
        this.topicMetadataTable.put(topic, metadata);
        this.persist();
        return metadata;
    }

    @Override
    public void updateTopicReserveTime(String topic, long reserveTime) {
        TopicMetadata metadata = this.getTopic(topic);
        if (metadata == null) {
            return;
        }
        metadata.setReserveTime(reserveTime);
        metadata.setUpdateTimestamp(System.currentTimeMillis());
        this.persist();
    }

    @Override
    public void updateTopicStatus(String topic, int status) {
        TopicMetadata metadata = this.getTopic(topic);
        if (metadata == null) {
            return;
        }
        metadata.setStatus(status);
        metadata.setUpdateTimestamp(System.currentTimeMillis());
        this.persist();
    }

    @Override
    public void deleteTopic(String topic) {
        this.topicMetadataTable.remove(topic);
        this.persist();
    }

    @Override
    @Nullable
    public QueueMetadata getQueue(MessageQueue queue) {
        if (!this.queueMetadataTable.containsKey(queue.getTopic())) {
            return null;
        }
        return (QueueMetadata)((ConcurrentMap)this.queueMetadataTable.get(queue.getTopic())).get(queue.getQueueId());
    }

    @Override
    public void iterateQueue(String topic, Consumer<QueueMetadata> callback) {
        ((ConcurrentMap)this.queueMetadataTable.get(topic)).values().forEach(callback);
    }

    @Override
    public QueueMetadata addQueue(MessageQueue queue, long baseOffset) {
        QueueMetadata old = this.getQueue(queue);
        if (old != null) {
            return old;
        }
        QueueMetadata metadata = new QueueMetadata(queue, baseOffset, baseOffset);
        this.queueMetadataTable.computeIfAbsent(queue.getTopic(), topic -> new ConcurrentHashMap()).put(queue.getQueueId(), metadata);
        this.persist();
        return metadata;
    }

    @Override
    public void updateQueue(QueueMetadata metadata) {
        ConcurrentMap metadataMap;
        MessageQueue queue = metadata.getQueue();
        if (this.queueMetadataTable.containsKey(queue.getTopic()) && (metadataMap = (ConcurrentMap)this.queueMetadataTable.get(queue.getTopic())).containsKey(queue.getQueueId())) {
            metadata.setUpdateTimestamp(System.currentTimeMillis());
            metadataMap.put(queue.getQueueId(), metadata);
            this.persist();
        }
    }

    @Override
    public void deleteQueue(MessageQueue queue) {
        if (this.queueMetadataTable.containsKey(queue.getTopic())) {
            ((ConcurrentMap)this.queueMetadataTable.get(queue.getTopic())).remove(queue.getQueueId());
        }
        this.persist();
    }

    @Override
    @Nullable
    public FileSegmentMetadata getFileSegment(TieredFileSegment fileSegment) {
        switch (fileSegment.getFileType()) {
            case COMMIT_LOG: {
                if (!this.commitLogFileSegmentTable.containsKey(fileSegment.getMessageQueue())) break;
                return (FileSegmentMetadata)((ConcurrentMap)this.commitLogFileSegmentTable.get(fileSegment.getMessageQueue())).get(fileSegment.getBaseOffset());
            }
            case CONSUME_QUEUE: {
                if (!this.consumeQueueFileSegmentTable.containsKey(fileSegment.getMessageQueue())) break;
                return (FileSegmentMetadata)((ConcurrentMap)this.consumeQueueFileSegmentTable.get(fileSegment.getMessageQueue())).get(fileSegment.getBaseOffset());
            }
            case INDEX: {
                if (!this.indexFileSegmentTable.containsKey(fileSegment.getMessageQueue())) break;
                return (FileSegmentMetadata)((ConcurrentMap)this.indexFileSegmentTable.get(fileSegment.getMessageQueue())).get(fileSegment.getBaseOffset());
            }
        }
        return null;
    }

    @Override
    public void iterateFileSegment(Consumer<FileSegmentMetadata> callback) {
        this.commitLogFileSegmentTable.forEach((mq, map) -> map.forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata)));
        this.consumeQueueFileSegmentTable.forEach((mq, map) -> map.forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata)));
        this.indexFileSegmentTable.forEach((mq, map) -> map.forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata)));
    }

    @Override
    public void iterateFileSegment(TieredFileSegment.FileSegmentType type, String topic, int queueId, Consumer<FileSegmentMetadata> callback) {
        MessageQueue messageQueue = new MessageQueue(topic, this.storeConfig.getBrokerName(), queueId);
        switch (type) {
            case COMMIT_LOG: {
                if (!this.commitLogFileSegmentTable.containsKey(messageQueue)) break;
                ((ConcurrentMap)this.commitLogFileSegmentTable.get(messageQueue)).forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata));
                break;
            }
            case CONSUME_QUEUE: {
                if (!this.consumeQueueFileSegmentTable.containsKey(messageQueue)) break;
                ((ConcurrentMap)this.consumeQueueFileSegmentTable.get(messageQueue)).forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata));
                break;
            }
            case INDEX: {
                if (!this.indexFileSegmentTable.containsKey(messageQueue)) break;
                ((ConcurrentMap)this.indexFileSegmentTable.get(messageQueue)).forEach((offset, metadata) -> callback.accept((FileSegmentMetadata)metadata));
            }
        }
    }

    @Override
    public FileSegmentMetadata updateFileSegment(TieredFileSegment fileSegment) {
        FileSegmentMetadata old = this.getFileSegment(fileSegment);
        if (old == null) {
            FileSegmentMetadata metadata = new FileSegmentMetadata(fileSegment.getMessageQueue(), fileSegment.getFileType().getType(), fileSegment.getBaseOffset(), fileSegment.getPath());
            if (fileSegment.isClosed()) {
                metadata.setStatus(2);
            }
            metadata.setBeginTimestamp(fileSegment.getBeginTimestamp());
            metadata.setEndTimestamp(fileSegment.getEndTimestamp());
            switch (fileSegment.getFileType()) {
                case COMMIT_LOG: {
                    this.commitLogFileSegmentTable.computeIfAbsent(fileSegment.getMessageQueue(), mq -> new ConcurrentHashMap()).put(fileSegment.getBaseOffset(), metadata);
                    break;
                }
                case CONSUME_QUEUE: {
                    this.consumeQueueFileSegmentTable.computeIfAbsent(fileSegment.getMessageQueue(), mq -> new ConcurrentHashMap()).put(fileSegment.getBaseOffset(), metadata);
                    break;
                }
                case INDEX: {
                    this.indexFileSegmentTable.computeIfAbsent(fileSegment.getMessageQueue(), mq -> new ConcurrentHashMap()).put(fileSegment.getBaseOffset(), metadata);
                }
            }
            this.persist();
            return metadata;
        }
        if (old.getStatus() == 0 && fileSegment.isFull() && !fileSegment.needCommit()) {
            old.setStatus(1);
            old.setSealTimestamp(System.currentTimeMillis());
        }
        if (fileSegment.isClosed()) {
            old.setStatus(2);
        }
        old.setSize(fileSegment.getCommitPosition());
        old.setBeginTimestamp(fileSegment.getBeginTimestamp());
        old.setEndTimestamp(fileSegment.getEndTimestamp());
        this.persist();
        return old;
    }

    @Override
    public void deleteFileSegment(MessageQueue mq) {
        this.commitLogFileSegmentTable.remove(mq);
        this.consumeQueueFileSegmentTable.remove(mq);
        this.indexFileSegmentTable.remove(mq);
        this.persist();
    }

    @Override
    public void deleteFileSegment(TieredFileSegment fileSegment) {
        switch (fileSegment.getFileType()) {
            case COMMIT_LOG: {
                if (!this.commitLogFileSegmentTable.containsKey(fileSegment.getMessageQueue())) break;
                ((ConcurrentMap)this.commitLogFileSegmentTable.get(fileSegment.getMessageQueue())).remove(fileSegment.getBaseOffset());
                break;
            }
            case CONSUME_QUEUE: {
                if (!this.consumeQueueFileSegmentTable.containsKey(fileSegment.getMessageQueue())) break;
                ((ConcurrentMap)this.consumeQueueFileSegmentTable.get(fileSegment.getMessageQueue())).remove(fileSegment.getBaseOffset());
                break;
            }
            case INDEX: {
                if (!this.indexFileSegmentTable.containsKey(fileSegment.getMessageQueue())) break;
                ((ConcurrentMap)this.indexFileSegmentTable.get(fileSegment.getMessageQueue())).remove(fileSegment.getBaseOffset());
            }
        }
        this.persist();
    }

    @Override
    public void destroy() {
        this.maxTopicId.set(0);
        this.topicMetadataTable.clear();
        this.queueMetadataTable.clear();
        this.commitLogFileSegmentTable.clear();
        this.consumeQueueFileSegmentTable.clear();
        this.indexFileSegmentTable.clear();
        this.persist();
    }
}

