/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.util.HashMap;
import java.util.List;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.MessageQueueView;
import org.apache.rocketmq.proxy.service.route.ProxyTopicRouteData;
import org.apache.rocketmq.proxy.service.route.TopicRouteService;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class LocalTopicRouteService
extends TopicRouteService {
    private final BrokerController brokerController;
    private final List<BrokerData> brokerDataList;
    private final int grpcPort;

    public LocalTopicRouteService(BrokerController brokerController, MQClientAPIFactory mqClientAPIFactory) {
        super(mqClientAPIFactory);
        this.brokerController = brokerController;
        BrokerConfig brokerConfig = this.brokerController.getBrokerConfig();
        HashMap<Long, String> brokerAddrs = new HashMap<Long, String>();
        brokerAddrs.put(0L, this.brokerController.getBrokerAddr());
        this.brokerDataList = Lists.newArrayList((Object[])new BrokerData[]{new BrokerData(brokerConfig.getBrokerClusterName(), brokerConfig.getBrokerName(), brokerAddrs)});
        this.grpcPort = ConfigurationManager.getProxyConfig().getGrpcServerPort();
    }

    @Override
    public MessageQueueView getCurrentMessageQueueView(String topic) throws Exception {
        TopicConfig topicConfig = (TopicConfig)this.brokerController.getTopicConfigManager().getTopicConfigTable().get(topic);
        return new MessageQueueView(topic, this.toTopicRouteData(topicConfig));
    }

    @Override
    public ProxyTopicRouteData getTopicRouteForProxy(List<Address> requestHostAndPortList, String topicName) throws Exception {
        MessageQueueView messageQueueView = this.getAllMessageQueueView(topicName);
        TopicRouteData topicRouteData = messageQueueView.getTopicRouteData();
        ProxyTopicRouteData proxyTopicRouteData = new ProxyTopicRouteData();
        proxyTopicRouteData.setQueueDatas(topicRouteData.getQueueDatas());
        for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
            ProxyTopicRouteData.ProxyBrokerData proxyBrokerData = new ProxyTopicRouteData.ProxyBrokerData();
            proxyBrokerData.setCluster(brokerData.getCluster());
            proxyBrokerData.setBrokerName(brokerData.getBrokerName());
            for (Long brokerId : brokerData.getBrokerAddrs().keySet()) {
                String brokerAddr = (String)brokerData.getBrokerAddrs().get(brokerId);
                HostAndPort brokerHostAndPort = HostAndPort.fromString((String)brokerAddr);
                HostAndPort grpcHostAndPort = HostAndPort.fromParts((String)brokerHostAndPort.getHost(), (int)this.grpcPort);
                proxyBrokerData.getBrokerAddrs().put(brokerId, Lists.newArrayList((Object[])new Address[]{new Address(Address.AddressScheme.IPv4, grpcHostAndPort)}));
            }
            proxyTopicRouteData.getBrokerDatas().add(proxyBrokerData);
        }
        return proxyTopicRouteData;
    }

    @Override
    public String getBrokerAddr(String brokerName) throws Exception {
        return this.brokerController.getBrokerAddr();
    }

    @Override
    public AddressableMessageQueue buildAddressableMessageQueue(MessageQueue messageQueue) throws Exception {
        String brokerAddress = this.getBrokerAddr(messageQueue.getBrokerName());
        return new AddressableMessageQueue(messageQueue, brokerAddress);
    }

    protected TopicRouteData toTopicRouteData(TopicConfig topicConfig) {
        TopicRouteData topicRouteData = new TopicRouteData();
        topicRouteData.setBrokerDatas(this.brokerDataList);
        QueueData queueData = new QueueData();
        queueData.setPerm(topicConfig.getPerm());
        queueData.setReadQueueNums(topicConfig.getReadQueueNums());
        queueData.setWriteQueueNums(topicConfig.getWriteQueueNums());
        queueData.setTopicSysFlag(topicConfig.getTopicSysFlag());
        queueData.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
        topicRouteData.setQueueDatas((List)Lists.newArrayList((Object[])new QueueData[]{queueData}));
        return topicRouteData;
    }
}

