/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.ITernaryOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class TernaryOperatorEmitter
extends JSSubEmitter
implements ISubEmitter<ITernaryOperatorNode> {
    public TernaryOperatorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(ITernaryOperatorNode node) {
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        IExpressionNode conditionalNode = node.getConditionalNode();
        this.getWalker().walk((IASNode)conditionalNode);
        IExpressionNode leftOperandNode = node.getLeftOperandNode();
        this.startMapping((ISourceLocation)node, (ISourceLocation)conditionalNode);
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.TERNARY);
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)leftOperandNode);
        IExpressionNode rightOperandNode = node.getRightOperandNode();
        this.startMapping((ISourceLocation)node, (ISourceLocation)leftOperandNode);
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.COLON);
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)rightOperandNode);
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }
}

