/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Strings;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;

final class CompilerOptionsPreprocessor {
    static void preprocess(CompilerOptions options) {
        if (options.checkMissingGetCssNameLevel.isOn() && Strings.isNullOrEmpty(options.checkMissingGetCssNameBlacklist)) {
            throw new InvalidOptionsException("Cannot check use of goog.getCssName because of empty blacklist.", new Object[0]);
        }
        if (options.removeUnusedPrototypePropertiesInExterns && !options.removeUnusedPrototypeProperties) {
            throw new InvalidOptionsException("remove_unused_prototype_props_in_externs requires remove_unused_prototype_props to be turned on.", new Object[0]);
        }
        if (options.getInlineFunctionsLevel() == CompilerOptions.Reach.NONE && options.maxFunctionSizeAfterInlining != -1) {
            throw new InvalidOptionsException("max_function_size_after_inlining has no effect if inlining is disabled.", new Object[0]);
        }
        if (options.dartPass) {
            if (!options.getOutputFeatureSet().contains(FeatureSet.ES5)) {
                throw new InvalidOptionsException("Dart requires --language_out=ES5 or higher.", new Object[0]);
            }
            options.setAmbiguateProperties(false);
            options.setDisambiguateProperties(false);
        }
        if (options.removeUnusedPrototypePropertiesInExterns && options.exportLocalPropertyDefinitions) {
            throw new InvalidOptionsException("remove_unused_prototype_props_in_externs and export_local_property_definitions cannot be used together.", new Object[0]);
        }
    }

    private CompilerOptionsPreprocessor() {
    }

    public static class InvalidOptionsException
    extends RuntimeException {
        private InvalidOptionsException(String message, Object ... args) {
            super(SimpleFormat.format(message, args));
        }
    }
}

