/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.internal.definitions.MemberedDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.tree.as.IPackageNode;

public class PackageDefinition
extends MemberedDefinition
implements IPackageDefinition {
    private static final String STAR = "*";
    private static final String DOT_STAR = ".*";
    private IPackageDefinition.PackageKind packageKind = IPackageDefinition.PackageKind.CONCRETE;

    public static String getQualifiedPackageNameFromNamespaceURI(String uri) {
        String packageName = null;
        if (uri.equals(STAR)) {
            packageName = "";
        } else if (uri.endsWith(DOT_STAR)) {
            packageName = uri.substring(0, uri.length() - DOT_STAR.length());
        }
        return packageName;
    }

    public PackageDefinition(String packageName) {
        super(packageName);
        this.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
    }

    @Override
    public IPackageDefinition.PackageKind getPackageKind() {
        return this.packageKind;
    }

    public void setVirtual() {
        this.packageKind = IPackageDefinition.PackageKind.VIRTUAL;
    }

    @Override
    protected String toStorageName(String name) {
        return name;
    }

    @Override
    public String getBaseName() {
        return this.getStorageName();
    }

    @Override
    public String getQualifiedName() {
        return this.getStorageName();
    }

    @Override
    public IPackageNode getNode() {
        return (IPackageNode)super.getNode();
    }

    @Override
    protected void buildInnerString(StringBuilder sb) {
        String name = this.getQualifiedName();
        sb.append("package");
        sb.append(' ');
        sb.append(name.length() > 0 ? name : "\"\"");
    }
}

