/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IKeywordNode;

public class KeywordNode
extends FixedChildrenNode
implements IKeywordNode {
    private int keywordType;

    protected KeywordNode() {
    }

    public KeywordNode(IASToken keyword) {
        this.span(keyword);
        this.keywordType = keyword.getType();
    }

    protected KeywordNode(KeywordNode other) {
        this.keywordType = other.keywordType;
    }

    @Override
    public ASTNodeID getNodeID() {
        switch (this.keywordType) {
            case 45: {
                return ASTNodeID.KeywordFunctionID;
            }
            case 41: {
                return ASTNodeID.KeywordExtendsID;
            }
            case 44: {
                return ASTNodeID.KeywordImplementsID;
            }
            case 51: {
                return ASTNodeID.KeywordVarID;
            }
            case 48: {
                return ASTNodeID.KeywordGetID;
            }
            case 49: {
                return ASTNodeID.KeywordSetID;
            }
            case 155: {
                return ASTNodeID.KeywordNewID;
            }
            case 52: {
                return ASTNodeID.KeywordConstID;
            }
            case 43: {
                return ASTNodeID.KeywordClassID;
            }
            case 40: {
                return ASTNodeID.KeywordInterfaceID;
            }
            case 54: {
                return ASTNodeID.KeywordDefaultXMLNamespaceID;
            }
        }
        return ASTNodeID.UnknownID;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getKeyword());
        sb.append('\"');
        return true;
    }

    public int getKeywordId() {
        return this.keywordType;
    }

    public String getKeyword() {
        switch (this.keywordType) {
            case 45: {
                return "function";
            }
            case 41: {
                return "extends";
            }
            case 44: {
                return "implements";
            }
            case 51: {
                return "var";
            }
            case 48: {
                return "get";
            }
            case 49: {
                return "set";
            }
            case 155: {
                return "new";
            }
            case 52: {
                return "const";
            }
            case 43: {
                return "class";
            }
            case 40: {
                return "interface";
            }
            case 54: {
                return "default xml namespace";
            }
        }
        assert (false) : "Unknown keyword type " + this.keywordType;
        return "";
    }
}

