/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.reference;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.io.File;
import java.util.HashMap;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.JSTypeUtils;

public class ConstantReference
extends BaseReference {
    private JSType type;

    public ConstantReference(ReferenceModel model, Node node, String qualifiedName, JSDocInfo comment) {
        super(model, node, qualifiedName, node.getJSDocInfo());
    }

    public ConstantReference(ReferenceModel model, Node node, String qualifiedName, JSDocInfo comment, JSType type) {
        super(model, node, qualifiedName, node.getJSDocInfo());
        this.type = type;
    }

    public File getFile(File asSourceRoot) {
        String packageName = "";
        return new File(asSourceRoot, packageName + File.separator + this.getQualifiedName() + ".as");
    }

    @Override
    public void emit(StringBuilder sb) {
        sb.append("package ");
        sb.append("{\n");
        sb.append("\n");
        String type = JSTypeUtils.toConstantTypeString(this);
        String value = this.resolveValue(type);
        if (this.getQualifiedName().equals("undefined")) {
            sb.append(this.indent);
            sb.append("public const undefined:* = void 0;\n");
        } else if (this.getQualifiedName().equals("NaN")) {
            sb.append(this.indent);
            sb.append("public const NaN:Number = 0/0;\n");
        } else if (this.getQualifiedName().equals("Infinity")) {
            sb.append(this.indent);
            sb.append("public const Infinity:Number = 1/0;\n");
        } else {
            sb.append(this.indent);
            sb.append("public const " + this.getQualifiedName() + ":" + type + " = " + value + ";\n");
        }
        sb.append("}\n");
    }

    private String resolveValue(String type) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Number", "0");
        map.put("undefined", "0");
        map.put("Boolean", "false");
        if (map.containsKey(type)) {
            return (String)map.get(type);
        }
        return type.equals("*") ? "undefined" : "null";
    }
}

