/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright;

import com.microsoft.playwright.APIRequestContext;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.Tracing;
import com.microsoft.playwright.options.BindingCallback;
import com.microsoft.playwright.options.Cookie;
import com.microsoft.playwright.options.FunctionCallback;
import com.microsoft.playwright.options.Geolocation;
import com.microsoft.playwright.options.HarNotFound;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public interface BrowserContext
extends AutoCloseable {
    public void onClose(Consumer<BrowserContext> var1);

    public void offClose(Consumer<BrowserContext> var1);

    public void onPage(Consumer<Page> var1);

    public void offPage(Consumer<Page> var1);

    public void onRequest(Consumer<Request> var1);

    public void offRequest(Consumer<Request> var1);

    public void onRequestFailed(Consumer<Request> var1);

    public void offRequestFailed(Consumer<Request> var1);

    public void onRequestFinished(Consumer<Request> var1);

    public void offRequestFinished(Consumer<Request> var1);

    public void onResponse(Consumer<Response> var1);

    public void offResponse(Consumer<Response> var1);

    public void addCookies(List<Cookie> var1);

    public void addInitScript(String var1);

    public void addInitScript(Path var1);

    public Browser browser();

    public void clearCookies();

    public void clearPermissions();

    @Override
    public void close();

    default public List<Cookie> cookies() {
        return this.cookies((String)null);
    }

    public List<Cookie> cookies(String var1);

    public List<Cookie> cookies(List<String> var1);

    default public void exposeBinding(String name, BindingCallback callback) {
        this.exposeBinding(name, callback, null);
    }

    public void exposeBinding(String var1, BindingCallback var2, ExposeBindingOptions var3);

    public void exposeFunction(String var1, FunctionCallback var2);

    default public void grantPermissions(List<String> permissions) {
        this.grantPermissions(permissions, null);
    }

    public void grantPermissions(List<String> var1, GrantPermissionsOptions var2);

    public Page newPage();

    public List<Page> pages();

    public APIRequestContext request();

    default public void route(String url, Consumer<Route> handler) {
        this.route(url, handler, null);
    }

    public void route(String var1, Consumer<Route> var2, RouteOptions var3);

    default public void route(Pattern url, Consumer<Route> handler) {
        this.route(url, handler, null);
    }

    public void route(Pattern var1, Consumer<Route> var2, RouteOptions var3);

    default public void route(Predicate<String> url, Consumer<Route> handler) {
        this.route(url, handler, null);
    }

    public void route(Predicate<String> var1, Consumer<Route> var2, RouteOptions var3);

    default public void routeFromHAR(Path har) {
        this.routeFromHAR(har, null);
    }

    public void routeFromHAR(Path var1, RouteFromHAROptions var2);

    public void setDefaultNavigationTimeout(double var1);

    public void setDefaultTimeout(double var1);

    public void setExtraHTTPHeaders(Map<String, String> var1);

    public void setGeolocation(Geolocation var1);

    public void setOffline(boolean var1);

    default public String storageState() {
        return this.storageState(null);
    }

    public String storageState(StorageStateOptions var1);

    public Tracing tracing();

    default public void unroute(String url) {
        this.unroute(url, null);
    }

    public void unroute(String var1, Consumer<Route> var2);

    default public void unroute(Pattern url) {
        this.unroute(url, null);
    }

    public void unroute(Pattern var1, Consumer<Route> var2);

    default public void unroute(Predicate<String> url) {
        this.unroute(url, null);
    }

    public void unroute(Predicate<String> var1, Consumer<Route> var2);

    default public Page waitForPage(Runnable callback) {
        return this.waitForPage(null, callback);
    }

    public Page waitForPage(WaitForPageOptions var1, Runnable var2);

    public static class WaitForPageOptions {
        public Predicate<Page> predicate;
        public Double timeout;

        public WaitForPageOptions setPredicate(Predicate<Page> predicate) {
            this.predicate = predicate;
            return this;
        }

        public WaitForPageOptions setTimeout(double timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static class StorageStateOptions {
        public Path path;

        public StorageStateOptions setPath(Path path) {
            this.path = path;
            return this;
        }
    }

    public static class RouteFromHAROptions {
        public HarNotFound notFound;
        public Boolean update;
        public Object url;

        public RouteFromHAROptions setNotFound(HarNotFound notFound) {
            this.notFound = notFound;
            return this;
        }

        public RouteFromHAROptions setUpdate(boolean update) {
            this.update = update;
            return this;
        }

        public RouteFromHAROptions setUrl(String url) {
            this.url = url;
            return this;
        }

        public RouteFromHAROptions setUrl(Pattern url) {
            this.url = url;
            return this;
        }
    }

    public static class RouteOptions {
        public Integer times;

        public RouteOptions setTimes(int times) {
            this.times = times;
            return this;
        }
    }

    public static class GrantPermissionsOptions {
        public String origin;

        public GrantPermissionsOptions setOrigin(String origin) {
            this.origin = origin;
            return this;
        }
    }

    public static class ExposeBindingOptions {
        public Boolean handle;

        public ExposeBindingOptions setHandle(boolean handle) {
            this.handle = handle;
            return this;
        }
    }
}

