/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleNames;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ModuleResolver {
    protected final ImmutableSet<String> modulePaths;
    protected final ImmutableList<String> moduleRootPaths;
    protected ErrorHandler errorHandler;
    private final ModuleLoader.PathEscaper pathEscaper;

    public ModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
        this.modulePaths = modulePaths;
        this.moduleRootPaths = moduleRootPaths;
        this.errorHandler = errorHandler;
        this.pathEscaper = pathEscaper;
    }

    Map<String, String> getPackageJsonMainEntries() {
        return ImmutableMap.of();
    }

    @Nullable
    public abstract String resolveJsModule(String var1, String var2, String var3, int var4, int var5);

    public String resolveModuleAsPath(String scriptAddress, String moduleAddress) {
        if (!moduleAddress.endsWith(".js")) {
            moduleAddress = moduleAddress + ".js";
        }
        String path = this.pathEscaper.escape(moduleAddress);
        if (ModuleLoader.isRelativeIdentifier(moduleAddress)) {
            String ourPath = scriptAddress;
            int lastIndex = ourPath.lastIndexOf("/");
            path = ModuleNames.canonicalizePath(ourPath.substring(0, lastIndex + "/".length()) + path);
        }
        return ModuleLoader.normalize(path, this.moduleRootPaths);
    }

    @Nullable
    protected String locate(String scriptAddress, String name) {
        String canonicalizedPath;
        String normalizedPath = canonicalizedPath = this.canonicalizePath(scriptAddress, name);
        if (ModuleLoader.isAmbiguousIdentifier(canonicalizedPath)) {
            normalizedPath = "/" + canonicalizedPath;
        }
        if (this.modulePaths.contains(normalizedPath)) {
            return canonicalizedPath;
        }
        for (String rootPath : this.moduleRootPaths) {
            String modulePath = rootPath + normalizedPath;
            if (!this.modulePaths.contains(modulePath)) continue;
            return canonicalizedPath;
        }
        return null;
    }

    protected String canonicalizePath(String scriptAddress, String moduleAddress) {
        String path = this.pathEscaper.escape(moduleAddress);
        if (ModuleLoader.isRelativeIdentifier(moduleAddress)) {
            String ourPath = scriptAddress;
            int lastIndex = ourPath.lastIndexOf("/");
            path = ModuleNames.canonicalizePath(ourPath.substring(0, lastIndex + "/".length()) + path);
        }
        return path;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

