/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common;

import java.awt.RenderingHints;
import java.util.Set;
import org.apache.sedona.common.Functions;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FunctionsGeoTools {
    public static Geometry transform(Geometry geometry, String targetCRS) throws FactoryException, TransformException {
        return FunctionsGeoTools.transform(geometry, null, targetCRS, true);
    }

    public static Geometry transform(Geometry geometry, String sourceCRS, String targetCRS) throws FactoryException, TransformException {
        return FunctionsGeoTools.transform(geometry, sourceCRS, targetCRS, true);
    }

    public static Geometry transform(Geometry geometry, String sourceCRScode, String targetCRScode, boolean lenient) throws FactoryException, TransformException {
        CoordinateReferenceSystem targetCRS = FunctionsGeoTools.parseCRSString(targetCRScode);
        return FunctionsGeoTools.transformToGivenTarget(geometry, sourceCRScode, targetCRS, lenient);
    }

    public static Geometry transformToGivenTarget(Geometry geometry, String sourceCRScode, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException, TransformException {
        if (sourceCRScode == null) {
            int srid = geometry.getSRID();
            if (srid != 0) {
                sourceCRScode = "epsg:" + srid;
            } else {
                throw new IllegalArgumentException("Source CRS must be specified. No SRID found on geometry.");
            }
        }
        CoordinateReferenceSystem sourceCRS = FunctionsGeoTools.parseCRSString(sourceCRScode);
        int targetSRID = FunctionsGeoTools.crsToSRID(targetCRS);
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
            Geometry transformed = JTS.transform((Geometry)geometry, (MathTransform)transform);
            transformed = Functions.setSRID(transformed, targetSRID);
            transformed.setUserData(geometry.getUserData());
            return transformed;
        }
        if (geometry.getSRID() != targetSRID) {
            Geometry transformed = Functions.setSRID(geometry, targetSRID);
            transformed.setUserData(geometry.getUserData());
            return transformed;
        }
        return geometry;
    }

    public static int wktCRSToSRID(String crsWKT) {
        try {
            Integer epsgCode;
            CoordinateReferenceSystem crs = CRS.parseWKT((String)crsWKT);
            int srid = FunctionsGeoTools.crsToSRID(crs);
            if (srid == 0 && (epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true)) != null) {
                srid = epsgCode;
            }
            return srid;
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Cannot parse CRS WKT", e);
        }
    }

    public static int crsToSRID(CoordinateReferenceSystem crs) {
        Set crsIds = crs.getIdentifiers();
        for (ReferenceIdentifier crsId : crsIds) {
            if (!"EPSG".equals(crsId.getCodeSpace())) continue;
            return Integer.parseInt(crsId.getCode());
        }
        return 0;
    }

    public static CoordinateReferenceSystem sridToCRS(int srid) {
        try {
            return CRS.decode((String)("EPSG:" + srid), (boolean)true);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Cannot decode SRID " + srid, e);
        }
    }

    private static CoordinateReferenceSystem parseCRSString(String CRSString) throws FactoryException {
        try {
            return CRS.decode((String)CRSString, (boolean)true);
        }
        catch (NoSuchAuthorityCodeException e) {
            try {
                Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
                return ReferencingFactoryFinder.getCRSFactory((Hints)hints).createFromWKT(CRSString);
            }
            catch (FactoryException ex) {
                throw new FactoryException("First failed to read as a well-known CRS code: \n" + e.getMessage() + "\nThen failed to read as a WKT CRS string: \n" + ex.getMessage());
            }
        }
    }

    public static Geometry voronoiPolygons(Geometry geom, double tolerance, Geometry extendTo) {
        if (geom == null) {
            return null;
        }
        VoronoiDiagramBuilder builder = new VoronoiDiagramBuilder();
        builder.setSites(geom);
        builder.setTolerance(tolerance);
        if (extendTo != null) {
            builder.setClipEnvelope(extendTo.getEnvelopeInternal());
        } else {
            Envelope e = geom.getEnvelopeInternal();
            e.expandBy(Math.max(e.getWidth(), e.getHeight()));
            builder.setClipEnvelope(e);
        }
        return builder.getDiagram(geom.getFactory());
    }

    public static Geometry bufferSpheroid(Geometry geometry, double radius, BufferParameters params) throws IllegalArgumentException {
        int bestCRS = Functions.bestSRID(geometry);
        int originalCRS = geometry.getSRID();
        int WGS84CRS = 4326;
        if (Functions.crossesDateLine(geometry)) {
            Functions.shiftLongitude(geometry);
        }
        String sourceCRSCode = originalCRS == 0 ? "EPSG:4326" : "EPSG:" + originalCRS;
        String targetCRSCode = "EPSG:" + bestCRS;
        try {
            Geometry transformedGeometry = FunctionsGeoTools.transform(geometry, sourceCRSCode, targetCRSCode);
            Geometry bufferedGeometry = BufferOp.bufferOp(transformedGeometry, radius, params);
            int backTransformCRSCode = originalCRS == 0 ? 4326 : originalCRS;
            Geometry bufferedResult = FunctionsGeoTools.transform(bufferedGeometry, targetCRSCode, "EPSG:" + backTransformCRSCode);
            Functions.normalizeLongitude(bufferedResult);
            return bufferedResult;
        }
        catch (FactoryException | TransformException e) {
            throw new RuntimeException(e);
        }
    }
}

