/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning.quadtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.apache.sedona.core.spatialPartitioning.PartitioningUtils;
import org.apache.sedona.core.spatialPartitioning.QuadTreeRTPartitioning;
import org.apache.sedona.core.spatialPartitioning.quadtree.QuadRectangle;
import org.apache.sedona.core.spatialPartitioning.quadtree.StandardQuadTree;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;
import scala.Tuple2;

public class ExtendedQuadTree<T>
extends PartitioningUtils
implements Serializable {
    private final transient List<Envelope> samples = new ArrayList<Envelope>();
    private final Envelope boundary;
    private final int numPartitions;
    private StandardQuadTree<Integer> partitionTree;
    private HashMap<Integer, List<Envelope>> expandedBoundaries;
    private STRtree spatialExpandedBoundaryIndex;
    private boolean useNonOverlapped = false;

    public HashMap<Integer, List<Envelope>> getExpandedBoundaries() {
        return this.expandedBoundaries;
    }

    public STRtree getSpatialExpandedBoundaryIndex() {
        return this.spatialExpandedBoundaryIndex;
    }

    public ExtendedQuadTree(Envelope boundary, int numPartitions) {
        this.boundary = boundary;
        this.numPartitions = numPartitions;
    }

    public ExtendedQuadTree(ExtendedQuadTree<?> extendedQuadTree, boolean useNonOverlapped) {
        this.boundary = extendedQuadTree.boundary;
        this.numPartitions = extendedQuadTree.numPartitions;
        this.expandedBoundaries = extendedQuadTree.expandedBoundaries;
        this.spatialExpandedBoundaryIndex = extendedQuadTree.spatialExpandedBoundaryIndex;
        this.partitionTree = extendedQuadTree.partitionTree;
        this.useNonOverlapped = useNonOverlapped;
    }

    public Envelope getBoundary() {
        return this.boundary;
    }

    public int getPartitionNum() {
        return this.numPartitions;
    }

    public void insert(Envelope sample) {
        this.samples.add(sample);
    }

    @Override
    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry geometry) {
        if (this.useNonOverlapped) {
            Objects.requireNonNull(geometry, "spatialObject");
            Envelope envelope = geometry.getCentroid().getEnvelopeInternal();
            List<QuadRectangle> matchedPartitions = this.partitionTree.findZones(new QuadRectangle(envelope));
            Point point = geometry.getCentroid();
            HashSet<Tuple2> result = new HashSet<Tuple2>();
            for (QuadRectangle rectangle : matchedPartitions) {
                if (point != null && !new HalfOpenRectangle(rectangle.getEnvelope()).contains(point)) continue;
                result.add(new Tuple2((Object)rectangle.partitionId, (Object)geometry));
            }
            return result.iterator();
        }
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        Envelope objectEnvelope = geometry.getEnvelopeInternal();
        List intersectingIds = this.spatialExpandedBoundaryIndex.query(objectEnvelope);
        for (Integer partitionId : intersectingIds) {
            result.add(new Tuple2((Object)partitionId, (Object)geometry));
        }
        return result.iterator();
    }

    @Override
    public Set<Integer> getKeys(Geometry geometry) {
        if (!this.useNonOverlapped) {
            return this.partitionTree.getKeys(geometry.getCentroid());
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        Envelope objectEnvelope = geometry.getEnvelopeInternal();
        List intersectingIds = this.spatialExpandedBoundaryIndex.query(objectEnvelope);
        keys.addAll(intersectingIds);
        return keys;
    }

    @Override
    public List<Envelope> fetchLeafZones() {
        return this.partitionTree.fetchLeafZones();
    }

    public void build(int neighborSampleNumber) throws Exception {
        int minLevel = (int)Math.max(Math.log(this.numPartitions) / Math.log(4.0), 0.0);
        QuadTreeRTPartitioning quadTreeRTPartitioning = new QuadTreeRTPartitioning(this.samples, this.boundary, this.numPartitions, minLevel);
        this.partitionTree = quadTreeRTPartitioning.getPartitionTree();
        quadTreeRTPartitioning.buildSTRTree(this.samples, neighborSampleNumber);
        this.expandedBoundaries = quadTreeRTPartitioning.getMbrs();
        this.spatialExpandedBoundaryIndex = quadTreeRTPartitioning.getMbrSpatialIndex();
        this.samples.clear();
        this.partitionTree.dropElements();
    }

    public StandardQuadTree<?> getQuadTree() {
        return this.partitionTree;
    }
}

