/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Stack;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.util.Assert;

public class ConvexHull {
    private static final int TUNING_REDUCE_SIZE = 50;
    private GeometryFactory geomFactory;
    private Coordinate[] inputPts;

    public ConvexHull(Geometry geometry) {
        this(geometry.getCoordinates(), geometry.getFactory());
    }

    public ConvexHull(Coordinate[] pts, GeometryFactory geomFactory) {
        this.inputPts = pts;
        this.geomFactory = geomFactory;
    }

    public Geometry getConvexHull() {
        Geometry fewPointsGeom = this.createFewPointsResult();
        if (fewPointsGeom != null) {
            return fewPointsGeom;
        }
        Coordinate[] reducedPts = this.inputPts;
        reducedPts = this.inputPts.length > 50 ? this.reduce(this.inputPts) : ConvexHull.extractUnique(this.inputPts);
        Coordinate[] sortedPts = this.preSort(reducedPts);
        Stack<Coordinate> cHS = this.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    private Geometry createFewPointsResult() {
        Coordinate[] uniquePts = ConvexHull.extractUnique(this.inputPts, 2);
        if (uniquePts == null) {
            return null;
        }
        if (uniquePts.length == 0) {
            return this.geomFactory.createGeometryCollection();
        }
        if (uniquePts.length == 1) {
            return this.geomFactory.createPoint(uniquePts[0]);
        }
        return this.geomFactory.createLineString(uniquePts);
    }

    private static Coordinate[] extractUnique(Coordinate[] pts) {
        return ConvexHull.extractUnique(pts, -1);
    }

    private static Coordinate[] extractUnique(Coordinate[] pts, int maxPts) {
        HashSet<Coordinate> uniquePts = new HashSet<Coordinate>();
        for (Coordinate pt : pts) {
            uniquePts.add(pt);
            if (maxPts < 0 || uniquePts.size() <= maxPts) continue;
            return null;
        }
        return CoordinateArrays.toCoordinateArray(uniquePts);
    }

    protected Coordinate[] toCoordinateArray(Stack<Coordinate> stack) {
        Coordinate[] coordinates = new Coordinate[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            Coordinate coordinate;
            coordinates[i] = coordinate = (Coordinate)stack.get(i);
        }
        return coordinates;
    }

    private Coordinate[] reduce(Coordinate[] inputPts) {
        int i;
        Coordinate[] innerPolyPts = this.computeInnerOctolateralRing(inputPts);
        if (innerPolyPts == null) {
            return inputPts;
        }
        HashSet<Coordinate> reducedSet = new HashSet<Coordinate>();
        for (i = 0; i < innerPolyPts.length; ++i) {
            reducedSet.add(innerPolyPts[i]);
        }
        for (i = 0; i < inputPts.length; ++i) {
            if (PointLocation.isInRing(inputPts[i], innerPolyPts)) continue;
            reducedSet.add(inputPts[i]);
        }
        Coordinate[] reducedPts = CoordinateArrays.toCoordinateArray(reducedSet);
        if (reducedPts.length < 3) {
            return this.padArray3(reducedPts);
        }
        return reducedPts;
    }

    private Coordinate[] padArray3(Coordinate[] pts) {
        Coordinate[] pad = new Coordinate[3];
        for (int i = 0; i < pad.length; ++i) {
            pad[i] = i < pts.length ? pts[i] : pts[0];
        }
        return pad;
    }

    private Coordinate[] preSort(Coordinate[] pts) {
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].y < pts[0].y) && (pts[i].y != pts[0].y || !(pts[i].x < pts[0].x))) continue;
            Coordinate t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        Arrays.sort(pts, 1, pts.length, new RadialComparator(pts[0]));
        return pts;
    }

    private Stack<Coordinate> grahamScan(Coordinate[] c) {
        Stack<Coordinate> ps = new Stack<Coordinate>();
        ps.push(c[0]);
        ps.push(c[1]);
        ps.push(c[2]);
        for (int i = 3; i < c.length; ++i) {
            Coordinate cp = c[i];
            Coordinate p = (Coordinate)ps.pop();
            while (!ps.empty() && Orientation.index(ps.peek(), p, cp) > 0) {
                p = ps.pop();
            }
            ps.push(p);
            ps.push(cp);
        }
        ps.push(c[0]);
        return ps;
    }

    private boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (Orientation.index(c1, c2, c3) != 0) {
            return false;
        }
        if (c1.x != c3.x) {
            if (c1.x <= c2.x && c2.x <= c3.x) {
                return true;
            }
            if (c3.x <= c2.x && c2.x <= c1.x) {
                return true;
            }
        }
        if (c1.y != c3.y) {
            if (c1.y <= c2.y && c2.y <= c3.y) {
                return true;
            }
            if (c3.y <= c2.y && c2.y <= c1.y) {
                return true;
            }
        }
        return false;
    }

    private Coordinate[] computeInnerOctolateralRing(Coordinate[] inputPts) {
        Coordinate[] octPts = this.computeInnerOctolateralPts(inputPts);
        CoordinateList coordList = new CoordinateList();
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private Coordinate[] computeInnerOctolateralPts(Coordinate[] inputPts) {
        Coordinate[] pts = new Coordinate[8];
        for (int j = 0; j < pts.length; ++j) {
            pts[j] = inputPts[0];
        }
        for (int i = 1; i < inputPts.length; ++i) {
            if (inputPts[i].x < pts[0].x) {
                pts[0] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y < pts[1].x - pts[1].y) {
                pts[1] = inputPts[i];
            }
            if (inputPts[i].y > pts[2].y) {
                pts[2] = inputPts[i];
            }
            if (inputPts[i].x + inputPts[i].y > pts[3].x + pts[3].y) {
                pts[3] = inputPts[i];
            }
            if (inputPts[i].x > pts[4].x) {
                pts[4] = inputPts[i];
            }
            if (inputPts[i].x - inputPts[i].y > pts[5].x - pts[5].y) {
                pts[5] = inputPts[i];
            }
            if (inputPts[i].y < pts[6].y) {
                pts[6] = inputPts[i];
            }
            if (!(inputPts[i].x + inputPts[i].y < pts[7].x + pts[7].y)) continue;
            pts[7] = inputPts[i];
        }
        return pts;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinates) {
        if ((coordinates = this.cleanRing(coordinates)).length == 3) {
            return this.geomFactory.createLineString(new Coordinate[]{coordinates[0], coordinates[1]});
        }
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinates);
        return this.geomFactory.createPolygon(linearRing);
    }

    private Coordinate[] cleanRing(Coordinate[] original) {
        Assert.equals(original[0], original[original.length - 1]);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        for (int i = 0; i <= original.length - 2; ++i) {
            Coordinate currentCoordinate = original[i];
            Coordinate nextCoordinate = original[i + 1];
            if (currentCoordinate.equals(nextCoordinate) || previousDistinctCoordinate != null && this.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate)) continue;
            cleanedRing.add(currentCoordinate);
            previousDistinctCoordinate = currentCoordinate;
        }
        cleanedRing.add(original[original.length - 1]);
        Coordinate[] cleanedRingCoordinates = new Coordinate[cleanedRing.size()];
        return cleanedRing.toArray(cleanedRingCoordinates);
    }

    private static class RadialComparator
    implements Comparator<Coordinate> {
        private Coordinate origin;

        public RadialComparator(Coordinate origin) {
            this.origin = origin;
        }

        @Override
        public int compare(Coordinate p1, Coordinate p2) {
            int comp = RadialComparator.polarCompare(this.origin, p1, p2);
            return comp;
        }

        private static int polarCompare(Coordinate o, Coordinate p, Coordinate q) {
            int orient = Orientation.index(o, p, q);
            if (orient == 1) {
                return 1;
            }
            if (orient == -1) {
                return -1;
            }
            if (p.y > q.y) {
                return 1;
            }
            if (p.y < q.y) {
                return -1;
            }
            if (p.x > q.x) {
                return 1;
            }
            if (p.x < q.x) {
                return -1;
            }
            return 0;
        }
    }
}

