/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Projections;

public final class S2BuilderSnapFunctions {
    private S2BuilderSnapFunctions() {
    }

    public static S1Angle maxSnapRadius() {
        return S1Angle.degrees(70.0);
    }

    public static class IntLatLngSnapFunction
    implements S2Builder.SnapFunction {
        public static final int MIN_EXPONENT = 0;
        public static final int MAX_EXPONENT = 10;
        private final int exponent;
        private final S1Angle snapRadius;
        private final double fromDegrees;
        private final double toDegrees;

        public IntLatLngSnapFunction(int exponent) {
            double power;
            Preconditions.checkArgument(exponent >= 0);
            Preconditions.checkArgument(exponent <= 10);
            this.exponent = exponent;
            this.snapRadius = IntLatLngSnapFunction.minSnapRadiusForExponent(exponent);
            this.fromDegrees = power = Math.pow(10.0, exponent);
            this.toDegrees = 1.0 / power;
        }

        public IntLatLngSnapFunction(int exponent, S1Angle snapRadius) {
            double power;
            Preconditions.checkArgument(exponent >= 0);
            Preconditions.checkArgument(exponent <= 10);
            Preconditions.checkState(snapRadius.greaterOrEquals(IntLatLngSnapFunction.minSnapRadiusForExponent(exponent)));
            Preconditions.checkState(snapRadius.lessOrEquals(S2BuilderSnapFunctions.maxSnapRadius()));
            this.exponent = exponent;
            this.snapRadius = snapRadius;
            this.fromDegrees = power = Math.pow(10.0, exponent);
            this.toDegrees = 1.0 / power;
        }

        public int exponent() {
            return this.exponent;
        }

        @Override
        public S1Angle snapRadius() {
            return this.snapRadius;
        }

        public static S1Angle minSnapRadiusForExponent(int exponent) {
            double power = 1.0;
            for (int i = 0; i < exponent; ++i) {
                power *= 10.0;
            }
            return S1Angle.degrees(S2.M_SQRT1_2 / power).add(S1Angle.radians((9.0 * S2.M_SQRT2 + 1.5) * 2.220446049250313E-16));
        }

        public static int exponentForMaxSnapRadius(S1Angle snapRadius) {
            snapRadius = snapRadius.sub(S1Angle.radians((9.0 * S2.M_SQRT2 + 1.5) * 2.220446049250313E-16));
            snapRadius = S1Angle.max(snapRadius, S1Angle.radians(1.0E-30));
            double exponent = Math.log10(S2.M_SQRT1_2 / snapRadius.degrees());
            return Math.max(0, Math.min(10, (int)Math.ceil(exponent - 4.440892098500626E-16)));
        }

        @Override
        public S1Angle minVertexSeparation() {
            return S1Angle.max(this.snapRadius.mul(0.471), this.snapRadius.sub(S1Angle.degrees(S2.M_SQRT1_2 * this.toDegrees)));
        }

        @Override
        public S1Angle minEdgeVertexSeparation() {
            S1Angle vertexSep = this.minVertexSeparation();
            return S1Angle.max(S1Angle.degrees(this.toDegrees).mul(0.277), S1Angle.max(this.snapRadius.mul(0.222), vertexSep.mul(0.5 * vertexSep.div(this.snapRadius))));
        }

        @Override
        public S2Point snapPoint(S2Point point) {
            Preconditions.checkState(this.exponent >= 0);
            S2LatLng input = new S2LatLng(point);
            long lat = Math.round(input.lat().degrees() * this.fromDegrees);
            long lng = Math.round(input.lng().degrees() * this.fromDegrees);
            return S2LatLng.fromDegrees((double)lat * this.toDegrees, (double)lng * this.toDegrees).toPoint();
        }

        public String toString() {
            return "IntLatLngSnapFunction with exponent " + this.exponent + " and snapRadius " + this.snapRadius;
        }
    }

    public static class S2CellIdSnapFunction
    implements S2Builder.SnapFunction {
        private final int level;
        private final S1Angle snapRadius;

        public S2CellIdSnapFunction() {
            this.level = 30;
            this.snapRadius = S2CellIdSnapFunction.minSnapRadiusForLevel(this.level);
        }

        public S2CellIdSnapFunction(int level) {
            Preconditions.checkArgument(level >= 0 && level <= 30);
            this.level = level;
            this.snapRadius = S2CellIdSnapFunction.minSnapRadiusForLevel(level);
        }

        public S2CellIdSnapFunction(int level, S1Angle snapRadius) {
            Preconditions.checkArgument(level >= 0 && level <= 30);
            Preconditions.checkArgument(snapRadius.lessOrEquals(S2CellIdSnapFunction.minSnapRadiusForLevel(level)));
            Preconditions.checkArgument(snapRadius.lessOrEquals(S2BuilderSnapFunctions.maxSnapRadius()));
            this.level = level;
            this.snapRadius = snapRadius;
        }

        public int level() {
            return this.level;
        }

        @Override
        public S1Angle snapRadius() {
            return this.snapRadius;
        }

        public static S1Angle minSnapRadiusForLevel(int level) {
            return S1Angle.radians(0.5 * S2Projections.MAX_DIAG.getValue(level) + 8.881784197001252E-16);
        }

        public static int levelForMaxSnapRadius(S1Angle snapRadius) {
            return S2Projections.MAX_DIAG.getMinLevel(2.0 * (snapRadius.radians() - 8.881784197001252E-16));
        }

        @Override
        public S1Angle minVertexSeparation() {
            S1Angle minEdge = S1Angle.radians(S2Projections.MIN_EDGE.getValue(this.level));
            S1Angle maxDiag = S1Angle.radians(S2Projections.MAX_DIAG.getValue(this.level));
            return S1Angle.max(minEdge, S1Angle.max(this.snapRadius.mul(0.548), this.snapRadius.sub(maxDiag.mul(0.5))));
        }

        @Override
        public S1Angle minEdgeVertexSeparation() {
            S1Angle minDiag = S1Angle.radians(S2Projections.MIN_DIAG.getValue(this.level));
            if (this.snapRadius().equals(S2CellIdSnapFunction.minSnapRadiusForLevel(this.level))) {
                return minDiag.mul(0.565);
            }
            S1Angle vertexSep = this.minVertexSeparation();
            return S1Angle.max(minDiag.mul(0.397), S1Angle.max(this.snapRadius.mul(0.219), vertexSep.mul(0.5 * vertexSep.div(this.snapRadius))));
        }

        @Override
        public S2Point snapPoint(S2Point point) {
            return S2CellId.fromPoint(point).parent(this.level).toPoint();
        }

        public String toString() {
            return "S2CellIdSnapFunction with level " + this.level + " and snapRadius " + this.snapRadius;
        }
    }

    public static class IdentitySnapFunction
    implements S2Builder.SnapFunction {
        private final S1Angle snapRadius;

        public IdentitySnapFunction() {
            this.snapRadius = S1Angle.ZERO;
        }

        public IdentitySnapFunction(S1Angle snapRadius) {
            Preconditions.checkArgument(snapRadius.lessOrEquals(S2BuilderSnapFunctions.maxSnapRadius()));
            this.snapRadius = snapRadius;
        }

        @Override
        public S1Angle snapRadius() {
            return this.snapRadius;
        }

        @Override
        public S1Angle minVertexSeparation() {
            return this.snapRadius;
        }

        @Override
        public S1Angle minEdgeVertexSeparation() {
            return this.snapRadius.mul(0.5);
        }

        @Override
        public S2Point snapPoint(S2Point point) {
            return point;
        }

        public String toString() {
            return "IdentitySnapFunction with snapRadius " + this.snapRadius;
        }
    }
}

