/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.execution.datasources.geoparquet.Covering;
import org.apache.spark.sql.execution.datasources.geoparquet.CoveringBBox;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.geoparquet.GeometryFieldMetaData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JField$;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class GeoParquetMetaData$
implements Serializable {
    public static final GeoParquetMetaData$ MODULE$ = new GeoParquetMetaData$();
    private static final String VERSION = "1.1.0";
    private static final String GEOPARQUET_VERSION_KEY = "geoparquet.version";
    private static final String GEOPARQUET_CRS_KEY = "geoparquet.crs";
    private static final String GEOPARQUET_COVERING_KEY = "geoparquet.covering";

    public String VERSION() {
        return VERSION;
    }

    public String GEOPARQUET_VERSION_KEY() {
        return GEOPARQUET_VERSION_KEY;
    }

    public String GEOPARQUET_CRS_KEY() {
        return GEOPARQUET_CRS_KEY;
    }

    public String GEOPARQUET_COVERING_KEY() {
        return GEOPARQUET_COVERING_KEY;
    }

    public Option<GeoParquetMetaData> parseKeyValueMetaData(Map<String, String> keyValueMetaData) {
        return Option$.MODULE$.apply((Object)keyValueMetaData.get("geo")).map((Function1 & Serializable)geo -> {
            scala.collection.immutable.Map columns;
            DefaultFormats$ formats = DefaultFormats$.MODULE$;
            JValue geoObject = JsonMethods$.MODULE$.parse(geo, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
            GeoParquetMetaData metadata = (GeoParquetMetaData)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.camelizeKeys$extension(package$.MODULE$.jvalue2monadic(geoObject))), (Formats)formats, ManifestFactory$.MODULE$.classType(GeoParquetMetaData.class));
            scala.collection.immutable.Map x$11 = columns = (scala.collection.immutable.Map)((MapOps)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(geoObject), "columns")), (Formats)formats, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(JValue.class)})))).map(arg_0 -> GeoParquetMetaData$.$anonfun$parseKeyValueMetaData$2((Formats)formats, arg_0));
            Option<String> x$12 = metadata.copy$default$1();
            String x$13 = metadata.copy$default$2();
            return metadata.copy(x$12, x$13, (scala.collection.immutable.Map<String, GeometryFieldMetaData>)x$11);
        });
    }

    public String toJson(GeoParquetMetaData geoParquetMetadata) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JValue geoObject = Extraction$.MODULE$.decompose((Object)geoParquetMetadata, (Formats)formats);
        scala.collection.immutable.Map columnsMap = (scala.collection.immutable.Map)((MapOps)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(geoObject), "columns")), (Formats)formats, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(JValue.class)})))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                JValue columnObject = (JValue)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)MonadicJValue$.MODULE$.underscoreKeys$extension(package$.MODULE$.jvalue2monadic(columnObject)));
            }
            throw new MatchError((Object)tuple2);
        });
        JValue serializedGeoObject = MonadicJValue$.MODULE$.mapField$extension(package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.underscoreKeys$extension(package$.MODULE$.jvalue2monadic(geoObject))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = tuple2;
                Object object = tuple22._1();
                String string = "columns";
                if (!(object != null ? !object.equals(string) : string != null)) {
                    return JField$.MODULE$.apply("columns", (JValue)new JObject(columnsMap.toList()));
                }
                return tuple2;
            }
            if (tuple2 != null) {
                Tuple2 tuple23 = tuple2;
                return tuple23;
            }
            throw new MatchError((Object)tuple2);
        });
        return org.json4s.jackson.package$.MODULE$.compactJson(serializedGeoObject);
    }

    public Covering createCoveringColumnMetadata(String coveringColumnName, StructType schema) {
        int coveringColumnIndex = schema.fieldIndex(coveringColumnName);
        DataType dataType = schema.apply(coveringColumnIndex).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.coveringColumnTypeToCovering(coveringColumnName, structType);
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Covering column ").append(coveringColumnName).append(" is not a struct type").toString());
    }

    private Covering coveringColumnTypeToCovering(String coveringColumnName, StructType coveringColumnType) {
        GeoParquetMetaData$.validateField$1("xmin", coveringColumnType, coveringColumnName);
        GeoParquetMetaData$.validateField$1("ymin", coveringColumnType, coveringColumnName);
        GeoParquetMetaData$.validateField$1("xmax", coveringColumnType, coveringColumnName);
        GeoParquetMetaData$.validateField$1("ymax", coveringColumnType, coveringColumnName);
        Option option = coveringColumnType.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetMetaData$.$anonfun$coveringColumnTypeToCovering$1(x$1)));
        if (option instanceof Some) {
            GeoParquetMetaData$.validateField$1("zmin", coveringColumnType, coveringColumnName);
            GeoParquetMetaData$.validateField$1("zmax", coveringColumnType, coveringColumnName);
            return new Covering(new CoveringBBox((Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmin", (List)Nil$.MODULE$)), (Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymin", (List)Nil$.MODULE$)), (Option<Seq<String>>)new Some((Object)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"zmin", (List)Nil$.MODULE$))), (Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmax", (List)Nil$.MODULE$)), (Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymax", (List)Nil$.MODULE$)), (Option<Seq<String>>)new Some((Object)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"zmax", (List)Nil$.MODULE$)))));
        }
        if (None$.MODULE$.equals(option)) {
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])coveringColumnType.fieldNames()), (Object)"zmax")) {
                throw new IllegalArgumentException(new StringBuilder(71).append("zmax should not present in covering column `").append(coveringColumnName).append("` since zmin is not present").toString());
            }
            return new Covering(new CoveringBBox((Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmin", (List)Nil$.MODULE$)), (Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymin", (List)Nil$.MODULE$)), (Option<Seq<String>>)None$.MODULE$, (Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmax", (List)Nil$.MODULE$)), (Seq<String>)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymax", (List)Nil$.MODULE$)), (Option<Seq<String>>)None$.MODULE$));
        }
        throw new MatchError((Object)option);
    }

    public GeoParquetMetaData apply(Option<String> version, String primaryColumn, scala.collection.immutable.Map<String, GeometryFieldMetaData> columns) {
        return new GeoParquetMetaData(version, primaryColumn, columns);
    }

    public Option<Tuple3<Option<String>, String, scala.collection.immutable.Map<String, GeometryFieldMetaData>>> unapply(GeoParquetMetaData x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3(x$0.version(), (Object)x$0.primaryColumn(), x$0.columns()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GeoParquetMetaData$.class);
    }

    public static final /* synthetic */ Tuple2 $anonfun$parseKeyValueMetaData$2(Formats formats$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            JValue columnObject = (JValue)tuple2._2();
            GeometryFieldMetaData fieldMetadata = (GeometryFieldMetaData)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.camelizeKeys$extension(package$.MODULE$.jvalue2monadic(columnObject))), formats$1, ManifestFactory$.MODULE$.classType(GeometryFieldMetaData.class));
            JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(columnObject), "crs");
            if (JNothing$.MODULE$.equals(jValue)) {
                None$ x$1 = None$.MODULE$;
                String x$2 = fieldMetadata.copy$default$1();
                Seq<String> x$3 = fieldMetadata.copy$default$2();
                Seq<Object> x$4 = fieldMetadata.copy$default$3();
                Option<Covering> x$5 = fieldMetadata.copy$default$5();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)fieldMetadata.copy(x$2, x$3, x$4, (Option<JValue>)x$1, x$5));
            }
            if (JNull$.MODULE$.equals(jValue)) {
                Some x$6 = new Some((Object)JNull$.MODULE$);
                String x$7 = fieldMetadata.copy$default$1();
                Seq<String> x$8 = fieldMetadata.copy$default$2();
                Seq<Object> x$9 = fieldMetadata.copy$default$3();
                Option<Covering> x$10 = fieldMetadata.copy$default$5();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)fieldMetadata.copy(x$7, x$8, x$9, (Option<JValue>)x$6, x$10));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)fieldMetadata);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void validateField$1(String fieldName, StructType coveringColumnType$1, String coveringColumnName$1) {
        DataType fieldType;
        int index = coveringColumnType$1.fieldIndex(fieldName);
        DataType dataType = fieldType = coveringColumnType$1.apply(index).dataType();
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType == null ? floatType$ != null : !dataType.equals(floatType$)) {
            DataType dataType2 = fieldType;
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            if (dataType2 == null ? doubleType$ != null : !dataType2.equals(doubleType$)) {
                throw new IllegalArgumentException(new StringBuilder(52).append("`").append(fieldName).append("` in covering column `").append(coveringColumnName$1).append("` is not float or double type").toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$coveringColumnTypeToCovering$1(StructField x$1) {
        String string = x$1.name();
        String string2 = "zmin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GeoParquetMetaData$() {
    }
}

