/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.VTfromExistingData;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VExplicitField
extends AbstractTransformBuilder
implements VertTransformBuilderIF {
    @Override
    public String getTransformName() {
        return VerticalCT.Type.Existing3DField.name();
    }

    @Override
    public VerticalCT makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv) {
        VerticalCT ct = new VerticalCT(ctv.getName(), this.getTransformName(), VerticalCT.Type.Existing3DField, this);
        String fieldName = ctv.findAttributeString("existingDataField", null);
        if (null == fieldName) {
            throw new IllegalArgumentException("ExplicitField Vertical Transform must have attribute existingDataField");
        }
        ct.addParameter(new Parameter("standard_name", this.getTransformName()));
        ct.addParameter(new Parameter("existingDataField", fieldName));
        return ct;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new VTfromExistingData(ds, timeDim, vCT.getParameters());
    }
}

