/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.Covering;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\rUa\u0001B A\u0001>C\u0001B\u001d\u0001\u0003\u0016\u0004%\ta\u001d\u0005\n\u0003\u0003\u0001!\u0011#Q\u0001\nQD!\"a\u0001\u0001\u0005+\u0007I\u0011AA\u0003\u0011)\t9\u0002\u0001B\tB\u0003%\u0011q\u0001\u0005\u000b\u00033\u0001!Q3A\u0005\u0002\u0005\u0015\u0001BCA\u000e\u0001\tE\t\u0015!\u0003\u0002\b!Q\u0011Q\u0004\u0001\u0003\u0016\u0004%\t!a\b\t\u0015\u00055\u0002A!E!\u0002\u0013\t\t\u0003\u0003\u0006\u00020\u0001\u0011)\u001a!C\u0001\u0003cA!\"!\u000f\u0001\u0005#\u0005\u000b\u0011BA\u001a\u0011)\tY\u0004\u0001BK\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u00033\u0002!\u0011#Q\u0001\n\u0005}\u0002BCA.\u0001\tU\r\u0011\"\u0001\u0002^!Q\u0011q\u000e\u0001\u0003\u0012\u0003\u0006I!a\u0018\t\u0015\u0005E\u0004A!f\u0001\n\u0003\t\u0019\b\u0003\u0006\u0002~\u0001\u0011\t\u0012)A\u0005\u0003kBq!a \u0001\t\u0003\t\t\tC\u0005\u0002\u0018\u0002\u0011\r\u0011\"\u0003\u0002\u001a\"A\u00111\u0014\u0001!\u0002\u0013\t9\bC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002\u001a\"A\u0011q\u0014\u0001!\u0002\u0013\t9\bC\u0005\u0002\"\u0002\u0001\r\u0011\"\u0003\u0002\u001a\"I\u00111\u0015\u0001A\u0002\u0013%\u0011Q\u0015\u0005\t\u0003c\u0003\u0001\u0015)\u0003\u0002x!I\u00111\u0017\u0001A\u0002\u0013%\u0011\u0011\u0014\u0005\n\u0003k\u0003\u0001\u0019!C\u0005\u0003oC\u0001\"a/\u0001A\u0003&\u0011q\u000f\u0005\n\u0003{\u0003!\u0019!C\u0001\u0003\u007fC\u0001\"!7\u0001A\u0003%\u0011\u0011\u0019\u0005\n\u00037\u0004!\u0019!C\u0005\u0003cA\u0001\"!8\u0001A\u0003%\u00111\u0007\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\t9\u000f\u0001C!\u0003SDq!a>\u0001\t\u0003\tI\u0010C\u0004\u0003\"\u0001!\tAa\t\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!\u0011\b\u0001\u0005B\tm\u0002\"\u0003B\"\u0001\u0005\u0005I\u0011\u0001B#\u0011%\u00119\u0006AI\u0001\n\u0003\u0011I\u0006C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0003r!I!Q\u000f\u0001\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005o\u0002\u0011\u0013!C\u0001\u0005sB\u0011B! \u0001#\u0003%\tAa \t\u0013\t\r\u0005!%A\u0005\u0002\t\u0015\u0005\"\u0003BE\u0001E\u0005I\u0011\u0001BF\u0011%\u0011y\tAI\u0001\n\u0003\u0011\t\nC\u0005\u0003\u0016\u0002\t\t\u0011\"\u0011\u0003\u0018\"I!Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0005?\u0003\u0011\u0011!C\u0001\u0005CC\u0011Ba+\u0001\u0003\u0003%\tE!,\t\u0013\t]\u0006!!A\u0005\u0002\te\u0006\"\u0003B_\u0001\u0005\u0005I\u0011\tB`\u0011%\u0011\u0019\rAA\u0001\n\u0003\u0012)\rC\u0005\u0003H\u0002\t\t\u0011\"\u0011\u0003J\"I!1\u001a\u0001\u0002\u0002\u0013\u0005#QZ\u0004\n\u0005#\u0004\u0015\u0011!E\u0001\u0005'4\u0001b\u0010!\u0002\u0002#\u0005!Q\u001b\u0005\b\u0003\u007fJD\u0011\u0001Bv\u0011%\u00119-OA\u0001\n\u000b\u0012I\rC\u0005\u0003nf\n\t\u0011\"!\u0003p\"I1\u0011A\u001d\u0002\u0002\u0013\u000551\u0001\u0005\n\u0007#I\u0014\u0011!C\u0005\u0007'\u0011\u0011b\u0015;bG\n\u000bGo\u00195\u000b\u0005\u0005\u0013\u0015\u0001B:uC\u000eT!a\u0011#\u0002\u0005%|'BA#G\u0003)\u0019X\rZ8oC~\u001b\u0018\u000f\u001c\u0006\u0003\u000f\"\u000b1a]9m\u0015\tI%*A\u0003ta\u0006\u00148N\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<7\u0001A\n\u0006\u0001AC\u0006M\u001a\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019y%M[3diB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005e\u0016\fGM\u0003\u0002^\r\u0006I1m\u001c8oK\u000e$xN]\u0005\u0003?j\u0013QAQ1uG\"\u0004\"!\u00193\u000e\u0003\tT\u0011aY\u0001\u0006g\u000e\fG.Y\u0005\u0003K\n\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002h_:\u0011\u0001.\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003W:\u000ba\u0001\u0010:p_Rt\u0014\"A2\n\u00059\u0014\u0017a\u00029bG.\fw-Z\u0005\u0003aF\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u001c2\u0002\u001b\t\u0014x.\u00193dCN$8i\u001c8g+\u0005!\bcA;yu6\taO\u0003\u0002x\u0011\u0006I!M]8bI\u000e\f7\u000f^\u0005\u0003sZ\u0014\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0005mtX\"\u0001?\u000b\u0005uD\u0015\u0001B;uS2L!a ?\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\\\u0001\u000fEJ|\u0017\rZ2bgR\u001cuN\u001c4!\u0003E\u0019H/Y2D_2dWm\u0019;j_:,&\u000f\\\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00129!\u00111BA\u0007!\tI'-C\u0002\u0002\u0010\t\fa\u0001\u0015:fI\u00164\u0017\u0002BA\n\u0003+\u0011aa\u0015;sS:<'bAA\bE\u0006\u00112\u000f^1d\u0007>dG.Z2uS>tWK\u001d7!\u0003I\u0019H/Y2D_2dWm\u0019;j_:T5o\u001c8\u0002'M$\u0018mY\"pY2,7\r^5p]*\u001bxN\u001c\u0011\u0002\rM\u001c\u0007.Z7b+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9CR\u0001\u0006if\u0004Xm]\u0005\u0005\u0003W\t)C\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa]2iK6\f\u0007%\u0001\u0003paR\u001cXCAA\u001a!!\tI!!\u000e\u0002\b\u0005\u001d\u0011\u0002BA\u001c\u0003+\u00111!T1q\u0003\u0015y\u0007\u000f^:!\u00035\u0019\b/\u0019;jC24\u0015\u000e\u001c;feV\u0011\u0011q\b\t\u0006C\u0006\u0005\u0013QI\u0005\u0004\u0003\u0007\u0012'AB(qi&|g\u000e\u0005\u0003\u0002H\u0005USBAA%\u0015\u0011\tY%!\u0014\u0002\u0015\u001d,w\u000e]1scV,GO\u0003\u0003\u0002P\u0005E\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT1!a\u0015G\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002X\u0005%#aF$f_B\u000b'/];fiN\u0003\u0018\r^5bY\u001aKG\u000e^3s\u00039\u0019\b/\u0019;jC24\u0015\u000e\u001c;fe\u0002\na\u0002^3na>\u0014\u0018\r\u001c$jYR,'/\u0006\u0002\u0002`A)\u0011-!\u0011\u0002bA!\u00111MA6\u001b\t\t)GC\u0002B\u0003ORA!!\u001b\u0002R\u0005QA-\u0019;bg>,(oY3\n\t\u00055\u0014Q\r\u0002\u000f)\u0016l\u0007o\u001c:bY\u001aKG\u000e^3s\u0003=!X-\u001c9pe\u0006dg)\u001b7uKJ\u0004\u0013a\u00037j[&$h)\u001b7uKJ,\"!!\u001e\u0011\u000b\u0005\f\t%a\u001e\u0011\u0007\u0005\fI(C\u0002\u0002|\t\u00141!\u00138u\u00031a\u0017.\\5u\r&dG/\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0011\u00121QAD\u0003\u0013\u000bY)!$\u0002\u0010\u0006E\u00151SAK!\r\t)\tA\u0007\u0002\u0001\")!/\u0005a\u0001i\"9\u00111A\tA\u0002\u0005\u001d\u0001bBA\r#\u0001\u0007\u0011q\u0001\u0005\b\u0003;\t\u0002\u0019AA\u0011\u0011\u001d\ty#\u0005a\u0001\u0003gAq!a\u000f\u0012\u0001\u0004\ty\u0004C\u0004\u0002\\E\u0001\r!a\u0018\t\u000f\u0005E\u0014\u00031\u0001\u0002v\u0005YB-\u001a4bk2$\u0018\n^3ng2KW.\u001b;QKJ\u0014V-];fgR,\"!a\u001e\u00029\u0011,g-Y;mi&#X-\\:MS6LG\u000fU3s%\u0016\fX/Z:uA\u0005y\u0012\u000e^3ng2{\u0017\r\u001a)s_\u000e,7o\u001d*fa>\u0014H\u000f\u00165sKNDw\u000e\u001c3\u0002A%$X-\\:M_\u0006$\u0007K]8dKN\u001c(+\u001a9peR$\u0006N]3tQ>dG\rI\u0001\fSR,W.T1y\u0019\u00164G/A\bji\u0016lW*\u0019=MK\u001a$x\fJ3r)\u0011\t9+!,\u0011\u0007\u0005\fI+C\u0002\u0002,\n\u0014A!\u00168ji\"I\u0011qV\f\u0002\u0002\u0003\u0007\u0011qO\u0001\u0004q\u0012\n\u0014\u0001D5uK6l\u0015\r\u001f'fMR\u0004\u0013a\u00047bgR\u0014V\r]8si\u000e{WO\u001c;\u0002'1\f7\u000f\u001e*fa>\u0014HoQ8v]R|F%Z9\u0015\t\u0005\u001d\u0016\u0011\u0018\u0005\n\u0003_S\u0012\u0011!a\u0001\u0003o\n\u0001\u0003\\1tiJ+\u0007o\u001c:u\u0007>,h\u000e\u001e\u0011\u0002\r5\f\u0007\u000f]3s+\t\t\t\r\u0005\u0003\u0002D\u0006UWBAAc\u0015\u0011\t9-!3\u0002\u0011\u0011\fG/\u00192j]\u0012TA!a3\u0002N\u00069!.Y2lg>t'\u0002BAh\u0003#\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005M\u0017aA2p[&!\u0011q[Ac\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\nq\u0001[3bI\u0016\u00148/\u0001\u0005iK\u0006$WM]:!\u00039\u0019X\r^%uK6l\u0015\r\u001f'fMR$B!a*\u0002d\"9\u0011Q\u001d\u0011A\u0002\u0005]\u0014!\u0002<bYV,\u0017a\u00059mC:Le\u000e];u!\u0006\u0014H/\u001b;j_:\u001cHCAAv!\u0015\t\u0017Q^Ay\u0013\r\tyO\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00043\u0006M\u0018bAA{5\nq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0017\u0001E2pY2,7\r^%uK6d\u0015N\\6t))\t9+a?\u0002\u0000\n\r!q\u0003\u0005\b\u0003{\u0014\u0003\u0019AA\u0004\u0003I\u0019w\u000e\u001c7fGRLwN\u001c\"bg\u0016\u0004\u0016\r\u001e5\t\u000f\t\u0005!\u00051\u0001\u0002\b\u0005q1m\u001c7mK\u000e$\u0018n\u001c8Kg>t\u0007b\u0002B\u0003E\u0001\u0007!qA\u0001\nSR,W\u000eT5oWN\u0004bA!\u0003\u0003\u0014\u0005\u001dQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u000f5,H/\u00192mK*\u0019!\u0011\u00032\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0016\t-!aC!se\u0006L()\u001e4gKJDqA!\u0007#\u0001\u0004\u0011Y\"\u0001\noK\u0016$7i\\;oi:+\u0007\u0010^%uK6\u001c\bcA1\u0003\u001e%\u0019!q\u00042\u0003\u000f\t{w\u000e\\3b]\u0006Yq-\u001a;Ji\u0016lG*\u001b8l))\t9A!\n\u0003*\t-\"Q\u0006\u0005\b\u0005O\u0019\u0003\u0019AA\u0004\u0003\u001dIG/Z7Ve2Dq!a&$\u0001\u0004\t9\bC\u0004\u0002<\r\u0002\r!a\u0010\t\u000f\u0005m3\u00051\u0001\u0002`\u0005\u0001b-\u001b7uKJ\u001cu\u000e\u001c7fGRLwN\u001c\u000b\t\u00057\u0011\u0019D!\u000e\u00038!9!\u0011\u0001\u0013A\u0002\u0005\u001d\u0001bBA\u001eI\u0001\u0007\u0011q\b\u0005\b\u00037\"\u0003\u0019AA0\u0003M\u0019'/Z1uKJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z)\t\u0011i\u0004E\u0002Z\u0005\u007fI1A!\u0011[\u0005Y\u0001\u0016M\u001d;ji&|gNU3bI\u0016\u0014h)Y2u_JL\u0018\u0001B2paf$\"#a!\u0003H\t%#1\nB'\u0005\u001f\u0012\tFa\u0015\u0003V!9!O\nI\u0001\u0002\u0004!\b\"CA\u0002MA\u0005\t\u0019AA\u0004\u0011%\tIB\nI\u0001\u0002\u0004\t9\u0001C\u0005\u0002\u001e\u0019\u0002\n\u00111\u0001\u0002\"!I\u0011q\u0006\u0014\u0011\u0002\u0003\u0007\u00111\u0007\u0005\n\u0003w1\u0003\u0013!a\u0001\u0003\u007fA\u0011\"a\u0017'!\u0003\u0005\r!a\u0018\t\u0013\u0005Ed\u0005%AA\u0002\u0005U\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00057R3\u0001\u001eB/W\t\u0011y\u0006\u0005\u0003\u0003b\t-TB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B5E\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5$1\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005gRC!a\u0002\u0003^\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005wRC!!\t\u0003^\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001BAU\u0011\t\u0019D!\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!q\u0011\u0016\u0005\u0003\u007f\u0011i&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t5%\u0006BA0\u0005;\nabY8qs\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003\u0014*\"\u0011Q\u000fB/\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0014\t\u0004#\nm\u0015bAA\n%\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BR\u0005S\u00032!\u0019BS\u0013\r\u00119K\u0019\u0002\u0004\u0003:L\b\"CAXc\u0005\u0005\t\u0019AA<\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BX!\u0019\u0011\tLa-\u0003$6\u0011!qB\u0005\u0005\u0005k\u0013yA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u000e\u0005wC\u0011\"a,4\u0003\u0003\u0005\rAa)\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00053\u0013\t\rC\u0005\u00020R\n\t\u00111\u0001\u0002x\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002x\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\u001a\u00061Q-];bYN$BAa\u0007\u0003P\"I\u0011qV\u001c\u0002\u0002\u0003\u0007!1U\u0001\n'R\f7MQ1uG\"\u00042!!\":'\u0015I$q\u001bBr!U\u0011INa8u\u0003\u000f\t9!!\t\u00024\u0005}\u0012qLA;\u0003\u0007k!Aa7\u000b\u0007\tu'-A\u0004sk:$\u0018.\\3\n\t\t\u0005(1\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:D\u0004\u0003\u0002Bs\u0005Sl!Aa:\u000b\u0005\r#\u0016b\u00019\u0003hR\u0011!1[\u0001\u0006CB\u0004H.\u001f\u000b\u0013\u0003\u0007\u0013\tPa=\u0003v\n](\u0011 B~\u0005{\u0014y\u0010C\u0003sy\u0001\u0007A\u000fC\u0004\u0002\u0004q\u0002\r!a\u0002\t\u000f\u0005eA\b1\u0001\u0002\b!9\u0011Q\u0004\u001fA\u0002\u0005\u0005\u0002bBA\u0018y\u0001\u0007\u00111\u0007\u0005\b\u0003wa\u0004\u0019AA \u0011\u001d\tY\u0006\u0010a\u0001\u0003?Bq!!\u001d=\u0001\u0004\t)(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u00151Q\u0002\t\u0006C\u0006\u00053q\u0001\t\u0013C\u000e%A/a\u0002\u0002\b\u0005\u0005\u00121GA \u0003?\n)(C\u0002\u0004\f\t\u0014a\u0001V;qY\u0016D\u0004\"CB\b{\u0005\u0005\t\u0019AAB\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002!\u0002")
public class StacBatch
implements Batch,
Product,
Serializable {
    private final Broadcast<SerializableConfiguration> broadcastConf;
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final Option<Object> limitFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;
    private final Map<String, String> headers;

    public static Option<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>> unapply(StacBatch x$0) {
        return StacBatch$.MODULE$.unapply(x$0);
    }

    public static StacBatch apply(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return StacBatch$.MODULE$.apply(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public static Function1<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<Broadcast<SerializableConfiguration>, Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, Function1<Option<Object>, StacBatch>>>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Broadcast<SerializableConfiguration> broadcastConf() {
        return this.broadcastConf;
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    public Option<Object> limitFilter() {
        return this.limitFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private Map<String, String> headers() {
        return this.headers;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        Some some;
        int limit;
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option<Object> option = this.limitFilter();
        int itemsLimitMax = option instanceof Some && (limit = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 0 ? limit : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable)() -> "1"))));
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((IterableOnceOps)((StrictOptimizedIterableOps)itemLinks.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String item = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                }
                throw new MatchError((Object)tuple2);
            })).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])((IterableOps)Random$.MODULE$.shuffle((IterableOnce)itemLinks, BuildFrom$.MODULE$.buildFromIterableOps())).grouped(partitionSize).zipWithIndex().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ArrayBuffer items = (ArrayBuffer)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            }
            throw new MatchError((Object)tuple2);
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                Growable growable = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(this.getItemLink(itemUrl, this.defaultItemsLimitPerRequest(), this.spatialFilter(), this.temporalFilter()), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, this.headers(), StacUtils$.MODULE$.loadStacCollectionToJson$default$3());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public String getItemLink(String itemUrl, int defaultItemsLimitPerRequest, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String baseUrl = new StringBuilder(7).append(itemUrl).append("?limit=").append(defaultItemsLimitPerRequest).toString();
        String urlWithFilters = StacUtils$.MODULE$.addFiltersToUrl(baseUrl, spatialFilter, temporalFilter);
        return urlWithFilters;
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl = !intervals.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader(this.broadcastConf(), (StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return new StacBatch(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public Broadcast<SerializableConfiguration> copy$default$1() {
        return this.broadcastConf();
    }

    public String copy$default$2() {
        return this.stacCollectionUrl();
    }

    public String copy$default$3() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$4() {
        return this.schema();
    }

    public Map<String, String> copy$default$5() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$6() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$7() {
        return this.temporalFilter();
    }

    public Option<Object> copy$default$8() {
        return this.limitFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.broadcastConf();
            }
            case 1: {
                return this.stacCollectionUrl();
            }
            case 2: {
                return this.stacCollectionJson();
            }
            case 3: {
                return this.schema();
            }
            case 4: {
                return this.opts();
            }
            case 5: {
                return this.spatialFilter();
            }
            case 6: {
                return this.temporalFilter();
            }
            case 7: {
                return this.limitFilter();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "broadcastConf";
            }
            case 1: {
                return "stacCollectionUrl";
            }
            case 2: {
                return "stacCollectionJson";
            }
            case 3: {
                return "schema";
            }
            case 4: {
                return "opts";
            }
            case 5: {
                return "spatialFilter";
            }
            case 6: {
                return "temporalFilter";
            }
            case 7: {
                return "limitFilter";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastConf();
        Broadcast<SerializableConfiguration> broadcast2 = stacBatch.broadcastConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.limitFilter();
        Option<Object> option6 = stacBatch.limitFilter();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), this.headers(), StacUtils$.MODULE$.loadStacCollectionToJson$default$3());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            .colon.colon geometryTypes = new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
            Seq bbox = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
            GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
            return filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LocalDateTime start = (LocalDateTime)tuple2._1();
            LocalDateTime end = (LocalDateTime)tuple2._2();
            return filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        }
        throw new MatchError((Object)tuple2);
    }

    public StacBatch(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        this.broadcastConf = broadcastConf;
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        this.limitFilter = limitFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        int limitPerRequest = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable)() -> "10")));
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable)() -> "1000000")));
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
        this.headers = StacUtils$.MODULE$.parseHeaders(opts);
    }
}

