/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.twak.camp.Corner;
import org.twak.camp.Edge;

public class Chain {
    List<Corner> chain = new ArrayList<Corner>();
    boolean loop;
    private static final Chain DELOOP = new Chain(new ArrayList<Corner>(), false);

    public Chain(List<Corner> chain) {
        this(chain, chain.get((int)(chain.size() - 1)).nextC == chain.get(0));
    }

    public Chain(List<Corner> chain, boolean loop) {
        this.loop = loop;
        this.chain = chain;
    }

    private Chain split(int index) {
        if (this.loop) {
            ArrayList<Corner> nc = new ArrayList<Corner>();
            nc.addAll(this.chain.subList(index, this.chain.size()));
            nc.addAll(this.chain.subList(0, index));
            this.loop = false;
            this.chain = nc;
            return DELOOP;
        }
        if (index == 0) {
            return null;
        }
        ArrayList<Corner> nc = new ArrayList<Corner>();
        nc.addAll(this.chain.subList(0, index));
        this.chain = this.chain.subList(index, this.chain.size());
        return new Chain(nc);
    }

    public List<Chain> removeCornersWithoutEdges(Set<Edge> liveEdges) {
        ArrayList<Chain> newChains = new ArrayList<Chain>();
        for (int i = 0; i < this.chain.size(); ++i) {
            Corner c = this.chain.get(i);
            if (liveEdges.contains(c.nextL)) continue;
            Chain n = this.split(i);
            this.chain.remove(0);
            if (n == DELOOP) {
                newChains.addAll(this.removeCornersWithoutEdges(liveEdges));
                return newChains;
            }
            if (n != null) {
                newChains.add(n);
            }
            i = -1;
        }
        return newChains;
    }

    public List<Chain> splitChainsIfHorizontal(Set<Corner> horizontals) {
        ArrayList<Chain> newChains = new ArrayList<Chain>();
        for (int i = 0; i < this.chain.size(); ++i) {
            Corner c = this.chain.get(i);
            if (!horizontals.contains(c)) continue;
            Chain n = this.split(i);
            if (n == DELOOP) {
                newChains.addAll(this.splitChainsIfHorizontal(horizontals));
                return newChains;
            }
            if (n != null) {
                newChains.add(n);
            }
            i = 0;
        }
        return newChains;
    }

    public String toString() {
        return this.chain.toString();
    }

    static interface Condition<E> {
        public boolean isTrue();
    }
}

