/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import javax.annotation.Nonnull;
import org.apache.sedona.shaded.guava.base.Preconditions;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

public abstract class PointFeatureImpl
implements PointFeature,
Comparable<PointFeature> {
    protected DsgFeatureCollection dsg;
    protected EarthLocation location;
    protected double obsTime;
    protected double nomTime;
    protected CalendarDateUnit timeUnit;

    protected PointFeatureImpl(DsgFeatureCollection dsg, CalendarDateUnit timeUnit) {
        this.dsg = Preconditions.checkNotNull(dsg, "dgs == null");
        this.timeUnit = timeUnit;
    }

    public PointFeatureImpl(DsgFeatureCollection dsg, EarthLocation location, double obsTime, double nomTime, CalendarDateUnit timeUnit) {
        this.dsg = Preconditions.checkNotNull(dsg, "dgs == null");
        this.location = Preconditions.checkNotNull(location, "location == null");
        this.obsTime = obsTime;
        this.nomTime = nomTime == 0.0 ? obsTime : nomTime;
        this.timeUnit = Preconditions.checkNotNull(timeUnit, "timeUnit == null");
    }

    @Override
    @Nonnull
    public DsgFeatureCollection getFeatureCollection() {
        return this.dsg;
    }

    @Override
    @Nonnull
    public EarthLocation getLocation() {
        return this.location;
    }

    @Override
    public double getNominalTime() {
        return this.nomTime;
    }

    @Override
    public double getObservationTime() {
        return this.obsTime;
    }

    public String getDescription() {
        return this.location.toString();
    }

    @Override
    @Nonnull
    public CalendarDate getObservationTimeAsCalendarDate() {
        return this.timeUnit.makeCalendarDate(this.getObservationTime());
    }

    @Override
    @Nonnull
    public CalendarDate getNominalTimeAsCalendarDate() {
        return this.timeUnit.makeCalendarDate(this.getNominalTime());
    }

    @Override
    public int compareTo(@Nonnull PointFeature other) {
        return Double.compare(this.obsTime, other.getObservationTime());
    }

    public String toString() {
        return "PointFeatureImpl{location=" + this.location + ", obsTime=" + this.obsTime + ", nomTime=" + this.nomTime + ", timeUnit=" + this.timeUnit + '}';
    }
}

