/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.servicecomb.foundation.common.utils.RestObjectMapper;

public final class JsonUtils {
    public static final ObjectMapper OBJ_MAPPER = new RestObjectMapper();
    private static final ObjectMapper UNICODE_OBJ_MAPPER = OBJ_MAPPER.copy();

    private JsonUtils() {
    }

    public static <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        return (T)OBJ_MAPPER.readValue(src, valueType);
    }

    public static <T> T readValue(InputStream is, Class<T> valueType) throws IOException {
        return (T)OBJ_MAPPER.readValue(is, valueType);
    }

    public static <T> T readValue(InputStream is, JavaType valueType) throws IOException {
        return (T)OBJ_MAPPER.readValue(is, valueType);
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return OBJ_MAPPER.writeValueAsBytes(value);
    }

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return OBJ_MAPPER.writeValueAsString(value);
    }

    public static String writeUnicodeValueAsString(Object value) throws JsonProcessingException {
        return UNICODE_OBJ_MAPPER.writeValueAsString(value);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)OBJ_MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) {
        return (T)OBJ_MAPPER.convertValue(fromValue, toValueType);
    }

    public static void writeValue(OutputStream out, Object value) throws IOException {
        OBJ_MAPPER.writeValue(out, value);
    }

    static {
        UNICODE_OBJ_MAPPER.enable(new JsonGenerator.Feature[]{JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature()});
    }
}

