/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.data;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.rule.attribute.datasource.aggregate.AggregatedDataSourceRuleAttribute;
import org.apache.shardingsphere.sharding.metadata.data.dialect.DialectShardingStatisticsTableCollector;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingStatisticsTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";

    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, ShardingSphereMetaData metaData) throws SQLException {
        ShardingSphereTableData result = new ShardingSphereTableData(SHARDING_TABLE_STATISTICS);
        DatabaseType protocolType = ((ShardingSphereDatabase)metaData.getAllDatabases().iterator().next()).getProtocolType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(protocolType).getDialectDatabaseMetaData();
        if (dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
            this.collectFromDatabase(metaData.getDatabase(databaseName), result);
        } else {
            for (ShardingSphereDatabase each : metaData.getAllDatabases()) {
                this.collectFromDatabase(each, result);
            }
        }
        return result.getRows().isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private void collectFromDatabase(ShardingSphereDatabase database, ShardingSphereTableData tableData) throws SQLException {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return;
        }
        this.collectForShardingStatisticTable(database, (ShardingRule)rule.get(), tableData);
    }

    private void collectForShardingStatisticTable(ShardingSphereDatabase database, ShardingRule rule, ShardingSphereTableData tableData) throws SQLException {
        int count = 1;
        for (ShardingTable each : rule.getShardingTables().values()) {
            for (DataNode dataNode : each.getActualDataNodes()) {
                LinkedList<Object> row = new LinkedList<Object>();
                row.add(count++);
                row.add(database.getName());
                row.add(each.getLogicTable());
                row.add(dataNode.getDataSourceName());
                row.add(dataNode.getTableName());
                this.addTableRowsAndDataLength(database.getResourceMetaData().getStorageUnits(), dataNode, row, rule);
                tableData.getRows().add(new ShardingSphereRowData(row));
            }
        }
    }

    private void addTableRowsAndDataLength(Map<String, StorageUnit> storageUnits, DataNode dataNode, List<Object> row, ShardingRule rule) throws SQLException {
        DatabaseType databaseType;
        DataSource dataSource;
        StorageUnit storageUnit = storageUnits.get(dataNode.getDataSourceName());
        if (null != storageUnit) {
            dataSource = storageUnit.getDataSource();
            databaseType = storageUnit.getStorageType();
        } else {
            Optional aggregatedDataSourceRuleAttribute = rule.getAttributes().findAttribute(AggregatedDataSourceRuleAttribute.class);
            dataSource = aggregatedDataSourceRuleAttribute.map(optional -> (DataSource)optional.getAggregatedDataSources().get(dataNode.getDataSourceName())).orElse(null);
            DatabaseType databaseType2 = databaseType = null != dataSource ? DatabaseTypeEngine.getStorageType((DataSource)dataSource) : null;
        }
        if (null != dataSource && null != databaseType) {
            this.addTableRowsAndDataLength(databaseType, dataSource, dataNode, row);
        }
    }

    private void addTableRowsAndDataLength(DatabaseType databaseType, DataSource dataSource, DataNode dataNode, List<Object> row) throws SQLException {
        boolean isAppended = false;
        Optional dialectCollector = DatabaseTypedSPILoader.findService(DialectShardingStatisticsTableCollector.class, (DatabaseType)databaseType);
        if (dialectCollector.isPresent()) {
            try (Connection connection = dataSource.getConnection();){
                isAppended = ((DialectShardingStatisticsTableCollector)dialectCollector.get()).appendRow(connection, dataNode, row);
            }
        }
        if (!isAppended) {
            row.add(BigDecimal.ZERO);
            row.add(BigDecimal.ZERO);
        }
    }

    public String getType() {
        return SHARDING_TABLE_STATISTICS;
    }
}

