/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection;

import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl.ParameterMarkerExpressionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection.impl.AggregationProjectionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection.impl.ColumnProjectionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection.impl.ExpressionProjectionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection.impl.ShorthandProjectionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.projection.impl.SubqueryProjectionConverter;

public final class ProjectionsConverter {
    public static Optional<SqlNodeList> convert(ProjectionsSegment segment) {
        LinkedList projectionSQLNodes = new LinkedList();
        for (ProjectionSegment each : segment.getProjections()) {
            ProjectionsConverter.getProjectionSQLNode(each).ifPresent(projectionSQLNodes::add);
        }
        return Optional.of(new SqlNodeList(projectionSQLNodes, SqlParserPos.ZERO));
    }

    private static Optional<SqlNode> getProjectionSQLNode(ProjectionSegment segment) {
        if (segment instanceof ColumnProjectionSegment) {
            return ColumnProjectionConverter.convert((ColumnProjectionSegment)segment);
        }
        if (segment instanceof ExpressionProjectionSegment) {
            return ExpressionProjectionConverter.convert((ExpressionProjectionSegment)segment);
        }
        if (segment instanceof ShorthandProjectionSegment) {
            return ShorthandProjectionConverter.convert((ShorthandProjectionSegment)segment);
        }
        if (segment instanceof SubqueryProjectionSegment) {
            return SubqueryProjectionConverter.convert((SubqueryProjectionSegment)segment);
        }
        if (segment instanceof AggregationProjectionSegment) {
            return AggregationProjectionConverter.convert((AggregationProjectionSegment)segment);
        }
        if (segment instanceof ParameterMarkerExpressionSegment) {
            return ParameterMarkerExpressionConverter.convert((ParameterMarkerExpressionSegment)segment);
        }
        return Optional.empty();
    }

    @Generated
    private ProjectionsConverter() {
    }
}

