/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCapabilityFlag;
import org.apache.shardingsphere.proxy.frontend.ssl.ProxySSLContext;

public final class MySQLSSLRequestHandler
extends ByteToMessageDecoder {
    private static final int HEADER_LENGTH = 4;
    private static final int SSL_REQUEST_LENGTH = 32;

    public MySQLSSLRequestHandler() {
        this.setSingleDecode(true);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 4 || in.readableBytes() < 4 + in.getUnsignedMediumLE(in.readerIndex())) {
            return;
        }
        if (this.isSSLRequest(in)) {
            SslHandler sslHandler = new SslHandler(ProxySSLContext.getInstance().newSSLEngine(context.alloc()));
            context.pipeline().addAfter(MySQLSSLRequestHandler.class.getSimpleName(), SslHandler.class.getSimpleName(), (ChannelHandler)sslHandler);
            in.skipBytes(36);
        }
        context.pipeline().remove((ChannelHandler)this);
    }

    private boolean isSSLRequest(ByteBuf in) {
        int clientCapabilitiesFlagOffset = 4 + in.readerIndex();
        return 32 == in.getUnsignedMediumLE(in.readerIndex()) && MySQLCapabilityFlag.CLIENT_SSL.getValue() == (MySQLCapabilityFlag.CLIENT_SSL.getValue() & in.getUnsignedShortLE(clientCapabilitiesFlagOffset));
    }
}

