/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.jdbc;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.agent.plugin.core.context.ShardingSphereDataSourceContext;
import org.apache.shardingsphere.agent.plugin.core.holder.ShardingSphereDataSourceContextHolder;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.GaugeMetricFamilyMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.MetricsExporter;

public final class JDBCMetaDataInfoExporter
implements MetricsExporter {
    private final MetricConfiguration config = new MetricConfiguration("jdbc_meta_data_info", MetricCollectorType.GAUGE_METRIC_FAMILY, "Meta data information of ShardingSphere-JDBC", Arrays.asList("driver_instance", "database", "type"));

    @Override
    public Optional<GaugeMetricFamilyMetricsCollector> export(String pluginType) {
        GaugeMetricFamilyMetricsCollector result = (GaugeMetricFamilyMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType);
        result.cleanMetrics();
        for (Map.Entry entry : ShardingSphereDataSourceContextHolder.getShardingSphereDataSourceContexts().entrySet()) {
            Optional.ofNullable(((ShardingSphereDataSourceContext)entry.getValue()).getContextManager().getDatabase(((ShardingSphereDataSourceContext)entry.getValue()).getDatabaseName())).ifPresent(optional -> result.addMetric(Arrays.asList((String)entry.getKey(), optional.getName(), "storage_unit_count"), optional.getResourceMetaData().getStorageUnits().size()));
        }
        return Optional.of(result);
    }
}

