/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.service;

import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.config.YamlPipelineJobItemProgressConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;

public final class PipelineJobItemManager<T extends PipelineJobItemProgress> {
    private final YamlPipelineJobItemProgressSwapper<YamlPipelineJobItemProgressConfiguration, T> swapper;

    public PipelineJobItemManager(YamlPipelineJobItemProgressSwapper swapper) {
        this.swapper = swapper;
    }

    public void updateStatus(String jobId, int shardingItem, JobStatus status) {
        Optional<T> jobItemProgress = this.getProgress(jobId, shardingItem);
        if (!jobItemProgress.isPresent()) {
            return;
        }
        ((PipelineJobItemProgress)jobItemProgress.get()).setStatus(status);
        PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobId)).getJobItemFacade().getProcess().update(jobId, shardingItem, YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration((PipelineJobItemProgress)jobItemProgress.get())));
    }

    public Optional<T> getProgress(String jobId, int shardingItem) {
        return PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobId)).getJobItemFacade().getProcess().load(jobId, shardingItem).map(optional -> (PipelineJobItemProgress)this.swapper.swapToObject((YamlPipelineJobItemProgressConfiguration)YamlEngine.unmarshal((String)optional, this.swapper.getYamlProgressClass(), (boolean)true)));
    }

    public void persistProgress(PipelineJobItemContext jobItemContext) {
        PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobItemContext.getJobId())).getJobItemFacade().getProcess().persist(jobItemContext.getJobId(), jobItemContext.getShardingItem(), this.convertProgressYamlContent(jobItemContext));
    }

    public void updateProgress(PipelineJobItemContext jobItemContext) {
        PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobItemContext.getJobId())).getJobItemFacade().getProcess().update(jobItemContext.getJobId(), jobItemContext.getShardingItem(), this.convertProgressYamlContent(jobItemContext));
    }

    private String convertProgressYamlContent(PipelineJobItemContext jobItemContext) {
        return YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(jobItemContext.toProgress()));
    }
}

