/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.task;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;

public final class PipelineTaskUtils {
    public static String generateInventoryTaskId(InventoryDumperContext dumperContext) {
        return String.format("%s.%s#%s", dumperContext.getCommonContext().getDataSourceName(), dumperContext.getActualTableName(), dumperContext.getShardingItem());
    }

    public static IncrementalTaskProgress createIncrementalTaskProgress(IngestPosition position, TransmissionJobItemProgress initProgress) {
        IncrementalTaskProgress result = new IncrementalTaskProgress(position);
        if (null != initProgress && null != initProgress.getIncremental()) {
            Optional.ofNullable(initProgress.getIncremental().getIncrementalTaskProgress()).ifPresent(optional -> result.setIncrementalTaskDelay(initProgress.getIncremental().getIncrementalTaskProgress().getIncrementalTaskDelay()));
        }
        return result;
    }

    @Generated
    private PipelineTaskUtils() {
    }
}

