// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Layout};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwMultiLayoutView")]
    pub struct MultiLayoutView(Object<ffi::AdwMultiLayoutView, ffi::AdwMultiLayoutViewClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::adw_multi_layout_view_get_type(),
    }
}

impl MultiLayoutView {
    #[doc(alias = "adw_multi_layout_view_new")]
    pub fn new() -> MultiLayoutView {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::adw_multi_layout_view_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`MultiLayoutView`] objects.
    ///
    /// This method returns an instance of [`MultiLayoutViewBuilder`](crate::builders::MultiLayoutViewBuilder) which can be used to create [`MultiLayoutView`] objects.
    pub fn builder() -> MultiLayoutViewBuilder {
        MultiLayoutViewBuilder::new()
    }

    #[doc(alias = "adw_multi_layout_view_add_layout")]
    pub fn add_layout(&self, layout: Layout) {
        unsafe {
            ffi::adw_multi_layout_view_add_layout(self.to_glib_none().0, layout.into_glib_ptr());
        }
    }

    #[doc(alias = "adw_multi_layout_view_get_child")]
    #[doc(alias = "get_child")]
    pub fn child(&self, id: &str) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_multi_layout_view_get_child(
                self.to_glib_none().0,
                id.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_multi_layout_view_get_layout")]
    #[doc(alias = "get_layout")]
    pub fn layout(&self) -> Option<Layout> {
        unsafe { from_glib_none(ffi::adw_multi_layout_view_get_layout(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_multi_layout_view_get_layout_by_name")]
    #[doc(alias = "get_layout_by_name")]
    pub fn layout_by_name(&self, name: &str) -> Option<Layout> {
        unsafe {
            from_glib_none(ffi::adw_multi_layout_view_get_layout_by_name(
                self.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_multi_layout_view_get_layout_name")]
    #[doc(alias = "get_layout_name")]
    #[doc(alias = "layout-name")]
    pub fn layout_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_multi_layout_view_get_layout_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_multi_layout_view_remove_layout")]
    pub fn remove_layout(&self, layout: &Layout) {
        unsafe {
            ffi::adw_multi_layout_view_remove_layout(
                self.to_glib_none().0,
                layout.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_multi_layout_view_set_child")]
    pub fn set_child(&self, id: &str, child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::adw_multi_layout_view_set_child(
                self.to_glib_none().0,
                id.to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_multi_layout_view_set_layout")]
    #[doc(alias = "layout")]
    pub fn set_layout(&self, layout: &Layout) {
        unsafe {
            ffi::adw_multi_layout_view_set_layout(self.to_glib_none().0, layout.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_multi_layout_view_set_layout_name")]
    #[doc(alias = "layout-name")]
    pub fn set_layout_name(&self, name: &str) {
        unsafe {
            ffi::adw_multi_layout_view_set_layout_name(
                self.to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "layout")]
    pub fn connect_layout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_layout_trampoline<F: Fn(&MultiLayoutView) + 'static>(
            this: *mut ffi::AdwMultiLayoutView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::layout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_layout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "layout-name")]
    pub fn connect_layout_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_layout_name_trampoline<F: Fn(&MultiLayoutView) + 'static>(
            this: *mut ffi::AdwMultiLayoutView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::layout-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_layout_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl Default for MultiLayoutView {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`MultiLayoutView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MultiLayoutViewBuilder {
    builder: glib::object::ObjectBuilder<'static, MultiLayoutView>,
}

impl MultiLayoutViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    pub fn layout(self, layout: &Layout) -> Self {
        Self {
            builder: self.builder.property("layout", layout.clone()),
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    pub fn layout_name(self, layout_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("layout-name", layout_name.into()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`MultiLayoutView`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> MultiLayoutView {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
