/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

// The test
namespace nss_test {
const uint8_t kP256CompressedSpki[] = {
    0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
    0x22, 0x00, 0x02, 0xd2, 0x10, 0xb0, 0xa6, 0xf9, 0xd9, 0xf0, 0x12, 0x86,
    0x80, 0x58, 0xb4, 0x3f, 0xa4, 0xf4, 0x71, 0x01, 0x85, 0x43, 0xbb, 0xa0,
    0x0c, 0x92, 0x50, 0xdf, 0x92, 0x57, 0xc2, 0xac, 0xae, 0x5d, 0xd1};

const uint8_t kP256Uncompressed[] = {
    0x04, 0xd2, 0x10, 0xb0, 0xa6, 0xf9, 0xd9, 0xf0, 0x12, 0x86, 0x80,
    0x58, 0xb4, 0x3f, 0xa4, 0xf4, 0x71, 0x01, 0x85, 0x43, 0xbb, 0xa0,
    0x0c, 0x92, 0x50, 0xdf, 0x92, 0x57, 0xc2, 0xac, 0xae, 0x5d, 0xd1,
    0xce, 0x03, 0x75, 0x52, 0xd4, 0x81, 0x45, 0x0c, 0xe3, 0x9b, 0x4d,
    0x10, 0x95, 0x70, 0x1b, 0x17, 0x5b, 0xfa, 0xb3, 0x4b, 0x8e, 0x6c,
    0x09, 0x9e, 0x18, 0xf1, 0xc1, 0x98, 0x35, 0x83, 0x61, 0xe8};

const uint8_t kP384CompressedSpki[] = {
    0x30, 0x46, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x32, 0x00, 0x02,
    0x21, 0x9c, 0x14, 0xd6, 0x66, 0x17, 0xb3, 0x6e, 0xc6, 0xd8, 0x85, 0x6b,
    0x38, 0x5b, 0x73, 0xa7, 0x4d, 0x34, 0x4f, 0xd8, 0xae, 0x75, 0xef, 0x04,
    0x64, 0x35, 0xdd, 0xa5, 0x4e, 0x3b, 0x44, 0xbd, 0x5f, 0xbd, 0xeb, 0xd1,
    0xd0, 0x8d, 0xd6, 0x9e, 0x2d, 0x7d, 0xc1, 0xdc, 0x21, 0x8c, 0xb4, 0x35};

const uint8_t kP384Uncompressed[] = {
    0x04, 0x21, 0x9c, 0x14, 0xd6, 0x66, 0x17, 0xb3, 0x6e, 0xc6, 0xd8,
    0x85, 0x6b, 0x38, 0x5b, 0x73, 0xa7, 0x4d, 0x34, 0x4f, 0xd8, 0xae,
    0x75, 0xef, 0x04, 0x64, 0x35, 0xdd, 0xa5, 0x4e, 0x3b, 0x44, 0xbd,
    0x5f, 0xbd, 0xeb, 0xd1, 0xd0, 0x8d, 0xd6, 0x9e, 0x2d, 0x7d, 0xc1,
    0xdc, 0x21, 0x8c, 0xb4, 0x35, 0xbd, 0x28, 0x13, 0x8c, 0xc7, 0x78,
    0x33, 0x7a, 0x84, 0x2f, 0x6b, 0xd6, 0x1b, 0x24, 0x0e, 0x74, 0x24,
    0x9f, 0x24, 0x66, 0x7c, 0x2a, 0x58, 0x10, 0xa7, 0x6b, 0xfc, 0x28,
    0xe0, 0x33, 0x5f, 0x88, 0xa6, 0x50, 0x1d, 0xec, 0x01, 0x97, 0x6d,
    0xa8, 0x5a, 0xfb, 0x00, 0x86, 0x9c, 0xb6, 0xac, 0xe8};

const uint8_t kP521CompressedSpki[] = {
    0x30, 0x58, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x44, 0x00, 0x03,
    0x01, 0x56, 0xf4, 0x79, 0xf8, 0xdf, 0x1e, 0x20, 0xa7, 0xff, 0xc0, 0x4c,
    0xe4, 0x20, 0xc3, 0xe1, 0x54, 0xae, 0x25, 0x19, 0x96, 0xbe, 0xe4, 0x2f,
    0x03, 0x4b, 0x84, 0xd4, 0x1b, 0x74, 0x3f, 0x34, 0xe4, 0x5f, 0x31, 0x1b,
    0x81, 0x3a, 0x9c, 0xde, 0xc8, 0xcd, 0xa5, 0x9b, 0xbb, 0xbd, 0x31, 0xd4,
    0x60, 0xb3, 0x29, 0x25, 0x21, 0xe7, 0xc1, 0xb7, 0x22, 0xe5, 0x66, 0x7c,
    0x03, 0xdb, 0x2f, 0xae, 0x75, 0x3f};

const uint8_t kP521Uncompressed[] = {
    0x04, 0x01, 0x56, 0xf4, 0x79, 0xf8, 0xdf, 0x1e, 0x20, 0xa7, 0xff, 0xc0,
    0x4c, 0xe4, 0x20, 0xc3, 0xe1, 0x54, 0xae, 0x25, 0x19, 0x96, 0xbe, 0xe4,
    0x2f, 0x03, 0x4b, 0x84, 0xd4, 0x1b, 0x74, 0x3f, 0x34, 0xe4, 0x5f, 0x31,
    0x1b, 0x81, 0x3a, 0x9c, 0xde, 0xc8, 0xcd, 0xa5, 0x9b, 0xbb, 0xbd, 0x31,
    0xd4, 0x60, 0xb3, 0x29, 0x25, 0x21, 0xe7, 0xc1, 0xb7, 0x22, 0xe5, 0x66,
    0x7c, 0x03, 0xdb, 0x2f, 0xae, 0x75, 0x3f, 0x01, 0x50, 0x17, 0x36, 0xcf,
    0xe2, 0x47, 0x39, 0x43, 0x20, 0xd8, 0xe4, 0xaf, 0xc2, 0xfd, 0x39, 0xb5,
    0xa9, 0x33, 0x10, 0x61, 0xb8, 0x1e, 0x22, 0x41, 0x28, 0x2b, 0x9e, 0x17,
    0x89, 0x18, 0x22, 0xb5, 0xb7, 0x9e, 0x05, 0x2f, 0x45, 0x97, 0xb5, 0x96,
    0x43, 0xfd, 0x39, 0x37, 0x9c, 0x51, 0xbd, 0x51, 0x25, 0xc4, 0xf4, 0x8b,
    0xc3, 0xf0, 0x25, 0xce, 0x3c, 0xd3, 0x69, 0x53, 0x28, 0x6c, 0xcb, 0x38,
    0xfb};

const uint8_t kP256CompressedSpkiWrongSign[] = {
    0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
    0x22, 0x00, 0x07, 0xd2, 0x10, 0xb0, 0xa6, 0xf9, 0xd9, 0xf0, 0x12, 0x86,
    0x80, 0x58, 0xb4, 0x3f, 0xa4, 0xf4, 0x71, 0x01, 0x85, 0x43, 0xbb, 0xa0,
    0x0c, 0x92, 0x50, 0xdf, 0x92, 0x57, 0xc2, 0xac, 0xae, 0x5d, 0xd1};

const uint8_t kP256CompressedSpkiWrongPointLength[] = {
    0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
    0x22, 0x00, 0x02, 0xd2, 0x10, 0xb0, 0xa6, 0xf9, 0xd9, 0xf0, 0x12, 0x86,
    0x80, 0x58, 0xb4, 0x3f, 0xa4, 0xf4, 0x71, 0x01, 0x85, 0x43, 0xbb, 0xa0,
    0x0c, 0x92, 0x50, 0xdf, 0x92, 0x57, 0xc2, 0xac, 0xae, 0x5d};

const uint8_t kP256CompressedSpkiNotOnCurve[] = {
    0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
    0x22, 0x00, 0x02, 0xd2, 0x10, 0xb0, 0xa6, 0xf9, 0xd9, 0xf0, 0x12, 0x86,
    0x80, 0x58, 0xb4, 0x3f, 0xa4, 0xf4, 0x71, 0x01, 0x85, 0x43, 0xbb, 0xa0,
    0x0c, 0x92, 0x50, 0xdf, 0x92, 0x57, 0xc2, 0xac, 0xae, 0x5d, 0xd2};
}  // namespace nss_test
