/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:35:08 GMT 2018
 */

package uk.ac.sanger.artemis.components.filetree;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JFrame;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.javax.swing.MockJFileChooser;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.filetree.LocalAndRemoteFileManager;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class LocalAndRemoteFileManager_ESTest extends LocalAndRemoteFileManager_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FileFilter fileFilter0 = LocalAndRemoteFileManager.getFeatureFilter();
      assertNotNull(fileFilter0);
      
      LocalAndRemoteFileManager localAndRemoteFileManager0 = null;
      try {
        localAndRemoteFileManager0 = new LocalAndRemoteFileManager((JFrame) null, fileFilter0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FileFilter fileFilter0 = LocalAndRemoteFileManager.getSequenceFilter();
      assertNotNull(fileFilter0);
      
      DelegateFileFilter delegateFileFilter0 = new DelegateFileFilter(fileFilter0);
      assertNotNull(delegateFileFilter0);
      
      MockFile mockFile0 = new MockFile("mS+' ");
      assertNotNull(mockFile0);
      
      boolean boolean0 = delegateFileFilter0.accept((File) mockFile0, ".genbank.gz");
      assertEquals("mS+' ", mockFile0.getName());
      assertFalse(mockFile0.isDirectory());
      assertEquals(0L, mockFile0.length());
      assertFalse(mockFile0.exists());
      assertEquals(0L, mockFile0.getTotalSpace());
      assertTrue(mockFile0.isFile());
      assertFalse(mockFile0.canExecute());
      assertFalse(mockFile0.canWrite());
      assertEquals("mS+' ", mockFile0.toString());
      assertFalse(mockFile0.canRead());
      assertFalse(mockFile0.isAbsolute());
      assertEquals(0L, mockFile0.getUsableSpace());
      assertFalse(mockFile0.isHidden());
      assertNull(mockFile0.getParent());
      assertEquals(0L, mockFile0.lastModified());
      assertEquals(0L, mockFile0.getFreeSpace());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FileFilter fileFilter0 = LocalAndRemoteFileManager.getFeatureFilter();
      assertNotNull(fileFilter0);
      
      DelegateFileFilter delegateFileFilter0 = new DelegateFileFilter(fileFilter0);
      assertNotNull(delegateFileFilter0);
      
      File file0 = MockFile.createTempFile("r*kNS(CH.feature.gz", "r*kNS(CH.embl");
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/r*kNS(CH.feature.gz0r*kNS(CH.embl", file0.toString());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("r*kNS(CH.feature.gz0r*kNS(CH.embl", file0.getName());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertNotNull(file0);
      
      boolean boolean0 = delegateFileFilter0.accept(file0, "r*kNS(CH.tab.gz");
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/r*kNS(CH.feature.gz0r*kNS(CH.embl", file0.toString());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("r*kNS(CH.feature.gz0r*kNS(CH.embl", file0.getName());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FileFilter fileFilter0 = LocalAndRemoteFileManager.getFeatureFilter();
      assertNotNull(fileFilter0);
      
      DelegateFileFilter delegateFileFilter0 = new DelegateFileFilter(fileFilter0);
      assertNotNull(delegateFileFilter0);
      
      File file0 = MockFile.createTempFile("r*k[S(CH.gff.gz", "r*k[S(CH.gff.gz");
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/r*k[S(CH.gff.gz0r*k[S(CH.gff.gz", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("r*k[S(CH.gff.gz0r*k[S(CH.gff.gz", file0.getName());
      assertNotNull(file0);
      
      boolean boolean0 = delegateFileFilter0.accept(file0, "_s=(OXt_");
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/r*k[S(CH.gff.gz0r*k[S(CH.gff.gz", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("r*k[S(CH.gff.gz0r*k[S(CH.gff.gz", file0.getName());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("mS+' /r*kNS(CH");
      FileFilter fileFilter0 = LocalAndRemoteFileManager.getFeatureFilter();
      assertNotNull(fileFilter0);
      
      DelegateFileFilter delegateFileFilter0 = new DelegateFileFilter(fileFilter0);
      assertNotNull(delegateFileFilter0);
      
      MockFile mockFile0 = new MockFile("mS+' ");
      assertNotNull(mockFile0);
      
      boolean boolean0 = FileSystemHandling.createFolder(evoSuiteFile0);
      assertTrue(boolean0);
      
      boolean boolean1 = delegateFileFilter0.accept((File) mockFile0, "r*kNS(CH");
      assertFalse(mockFile0.isAbsolute());
      assertEquals(0L, mockFile0.getTotalSpace());
      assertTrue(mockFile0.isDirectory());
      assertNull(mockFile0.getParent());
      assertEquals(0L, mockFile0.getFreeSpace());
      assertTrue(mockFile0.exists());
      assertEquals(1392409281320L, mockFile0.lastModified());
      assertEquals("mS+' ", mockFile0.toString());
      assertEquals(0L, mockFile0.length());
      assertTrue(mockFile0.canExecute());
      assertEquals(0L, mockFile0.getUsableSpace());
      assertTrue(mockFile0.canWrite());
      assertTrue(mockFile0.canRead());
      assertEquals("mS+' ", mockFile0.getName());
      assertFalse(mockFile0.isHidden());
      assertFalse(mockFile0.isFile());
      assertTrue(boolean1);
      assertTrue(boolean1 == boolean0);
  }
  
  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LocalAndRemoteFileManager.setAutomaticHistory(false);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      boolean boolean0 = LocalAndRemoteFileManager.isAutomaticHistory();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      LocalAndRemoteFileManager localAndRemoteFileManager0 = null;
      try {
        localAndRemoteFileManager0 = new LocalAndRemoteFileManager((JFrame) null);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FileFilter fileFilter0 = LocalAndRemoteFileManager.getFeatureFilter();
      DelegateFileFilter delegateFileFilter0 = new DelegateFileFilter(fileFilter0);
      File file0 = MockFile.createTempFile("r*kNS(CH.feature.gz", "r*kNS(CH.embl");
      delegateFileFilter0.accept(file0);
  }
}
