/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:04:34 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JFormattedTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatterFactory;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.variant.FilteredPanel;
import uk.ac.sanger.artemis.components.variant.HeaderLine;
import uk.ac.sanger.artemis.components.variant.RecordFilter;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class FilteredPanel_ESTest extends FilteredPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      LinkedList<HeaderLine> linkedList0 = new LinkedList<HeaderLine>();
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("86=.N '=(_", "86=.N '=(_", hashtable0);
      linkedList0.add(headerLine0);
      linkedList0.add(headerLine0);
      FilteredPanel filteredPanel0 = new FilteredPanel(linkedList0);
      assertFalse(filteredPanel0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      FilteredPanel filteredPanel0 = new FilteredPanel(keyVector0);
      filteredPanel0.removeFilter("");
      assertFalse(filteredPanel0.isFocusCycleRoot());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      LinkedList<HeaderLine> linkedList0 = new LinkedList<HeaderLine>();
      Hashtable<String, String> hashtable0 = new Hashtable<String, String>();
      HeaderLine headerLine0 = new HeaderLine("86=.N '=(_", "86=.N '=(_", hashtable0);
      linkedList0.add(headerLine0);
      FilteredPanel filteredPanel0 = new FilteredPanel(linkedList0);
      String string0 = FilteredPanel.getHeader();
      assertEquals("86=.N '=(_\n", string0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      List<HeaderLine> list0 = FilteredPanel.getHeaderLineFilters();
      assertTrue(list0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      FilteredPanel filteredPanel0 = new FilteredPanel(keyVector0);
      Object[] objectArray0 = new Object[2];
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(objectArray0, 168);
      keyVector0.insertElementAfter(defaultTableModel0, filteredPanel0);
      List<HeaderLine> list0 = FilteredPanel.getHeaderLineFilters();
      assertFalse(list0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      HeaderLine headerLine0 = mock(HeaderLine.class, new ViolatedAssumptionAnswer());
      doReturn("Asp").when(headerLine0).getDescription();
      doReturn("", "Asp").when(headerLine0).getType();
      doReturn(true).when(headerLine0).isFlag();
      filteredPanel0.addFilter("", headerLine0, 8);
      Hashtable<String, RecordFilter> hashtable0 = FilteredPanel.getFilters();
      assertFalse(hashtable0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      HeaderLine headerLine0 = mock(HeaderLine.class, new ViolatedAssumptionAnswer());
      doReturn("", "").when(headerLine0).getDescription();
      doReturn((-213), (-213)).when(headerLine0).getHeaderType();
      doReturn((String) null).when(headerLine0).getHeaderTypeStr();
      doReturn("", "i").when(headerLine0).getID();
      doReturn("", "").when(headerLine0).getType();
      doReturn(true, true, false).when(headerLine0).isFlag();
      filteredPanel0.addFilter("", headerLine0, 8);
      FilteredPanel.getHeader();
      FilteredPanel.getHeader();
      // Undeclared exception!
      try { 
        filteredPanel0.updateFilters();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FilteredPanel filteredPanel0 = null;
      try {
        filteredPanel0 = new FilteredPanel((List<HeaderLine>) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      KeyVector keyVector0 = new KeyVector(key0);
      FilteredPanel filteredPanel0 = null;
      try {
        filteredPanel0 = new FilteredPanel(keyVector0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Key cannot be cast to uk.ac.sanger.artemis.components.variant.HeaderLine
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      HeaderLine headerLine0 = mock(HeaderLine.class, new ViolatedAssumptionAnswer());
      doReturn("").when(headerLine0).getDescription();
      doReturn(1).when(headerLine0).getHeaderType();
      doReturn("").when(headerLine0).getID();
      doReturn("", "").when(headerLine0).getType();
      doReturn(true).when(headerLine0).isFlag();
      filteredPanel0.addFilter("", headerLine0, 1);
      String string0 = FilteredPanel.getHeader();
      assertEquals("##FILTER=<ID=sample,Description=\"\">\n", string0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      LinkedList<HeaderLine> linkedList0 = new LinkedList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(linkedList0);
      String string0 = FilteredPanel.getHeader();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      FilteredPanel filteredPanel0 = new FilteredPanel(keyVector0);
      Object[] objectArray0 = new Object[2];
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(objectArray0, 168);
      keyVector0.insertElementAfter(defaultTableModel0, filteredPanel0);
      // Undeclared exception!
      try { 
        FilteredPanel.getHeader();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.components.variant.FilteredPanel cannot be cast to uk.ac.sanger.artemis.components.variant.HeaderLine
         //
         verifyException("uk.ac.sanger.artemis.components.variant.FilteredPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Stack<HeaderLine> stack0 = new Stack<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(stack0);
      FilteredPanel.getHeaderLineFiltersIDs();
      List<String> list0 = FilteredPanel.getHeaderLineFiltersIDs();
      assertEquals(0, list0.size());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      ArrayList<HeaderLine> arrayList0 = new ArrayList<HeaderLine>();
      FilteredPanel filteredPanel0 = new FilteredPanel(arrayList0);
      HeaderLine headerLine0 = mock(HeaderLine.class, new ViolatedAssumptionAnswer());
      doReturn("").when(headerLine0).getDescription();
      doReturn("", "").when(headerLine0).getType();
      doReturn(true).when(headerLine0).isFlag();
      filteredPanel0.addFilter("", headerLine0, 8);
      filteredPanel0.updateFilters();
      assertFalse(filteredPanel0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      FilteredPanel filteredPanel0 = new FilteredPanel(keyVector0);
      // Undeclared exception!
      try { 
        filteredPanel0.removeFilter((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }
}
