/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 18:25:20 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.StreamFeatureTable;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class LineGroup_ESTest extends LineGroup_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      int int0 = LineGroup.getLineType(" to a Path.");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      int int0 = LineGroup.getLineType("ml/~i9)[_2u+I%$*b");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      int int0 = LineGroup.getLineType("CONTI");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      int int0 = LineGroup.getLineType("e IA0NZgv");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      int int0 = LineGroup.getLineType("   ");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MockFileOutputStream mockFileOutputStream0 = new MockFileOutputStream("<?xml");
      Charset charset0 = Charset.defaultCharset();
      CharsetEncoder charsetEncoder0 = charset0.newEncoder();
      OutputStreamWriter outputStreamWriter0 = new OutputStreamWriter(mockFileOutputStream0, charsetEncoder0);
      LineGroup.writeStartOfGFFEntry(outputStreamWriter0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        LineGroup.writeEndOfEMBLEntry((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LineGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MockFileOutputStream mockFileOutputStream0 = new MockFileOutputStream("<?xml");
      Charset charset0 = Charset.defaultCharset();
      CharsetEncoder charsetEncoder0 = charset0.newEncoder();
      OutputStreamWriter outputStreamWriter0 = new OutputStreamWriter(mockFileOutputStream0, charsetEncoder0);
      outputStreamWriter0.close();
      try { 
        LineGroup.writeEndOfEMBLEntry(outputStreamWriter0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        LineGroup.getLineType((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String string0 = LineGroup.getRestOfLine("deleteFeaturePub");
      assertEquals("eFeaturePub", string0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      String string0 = LineGroup.getRestOfLine("[");
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      int int0 = LineGroup.getLineType("e/ kA0NZ6ve");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      int int0 = LineGroup.getLineType("CONTIG");
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      int int0 = LineGroup.getLineType("feature_protein_programs");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      // Undeclared exception!
      try { 
        LineGroup.getLineType("nC\"");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      int int0 = LineGroup.getLineType("CS");
      assertEquals(6, int0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      int int0 = LineGroup.getLineType("1\"");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      // Undeclared exception!
      try { 
        LineGroup.getLineType("//CS");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      int int0 = LineGroup.getLineType("");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      StringReader stringReader0 = new StringReader("##Filter=");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      EmblStreamFeature emblStreamFeature0 = EmblStreamFeature.readFromStream(linePushBackReader0);
      assertNull(emblStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      int int0 = LineGroup.getLineType("<?xmlCONTIG");
      assertEquals(15, int0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("CS");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "eeUG3Jihx?-!{40=Z");
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MockFile mockFile0 = new MockFile((File) null, "CS");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      LogReadListener logReadListener0 = new LogReadListener("CS");
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(mSPcrunchEntryInformation0, fileDocument0, logReadListener0);
      assertFalse(emblDocumentEntry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("CS");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, " ");
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MockFile mockFile0 = new MockFile((File) null, "CS");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      LogReadListener logReadListener0 = new LogReadListener("CS");
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(mSPcrunchEntryInformation0, fileDocument0, logReadListener0);
      assertTrue(PublicDBDocumentEntry.IGNORE_OBSOLETE_FEATURES);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      StreamFeatureTable streamFeatureTable0 = new StreamFeatureTable();
      StringWriter stringWriter0 = new StringWriter(0);
      streamFeatureTable0.writeToStream(stringWriter0);
      assertEquals("", stringWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      MockFileWriter mockFileWriter0 = new MockFileWriter("<?xml");
      LineGroup.writeEndOfEMBLEntry(mockFileWriter0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      // Undeclared exception!
      try { 
        LineGroup.writeStartOfGFFEntry((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LineGroup", e);
      }
  }
}
